package plus.easydo.starter.job.auto.annotion;


import plus.easydo.starter.job.auto.config.BlockStrategy;
import plus.easydo.starter.job.auto.config.GlueTypeEnum;
import plus.easydo.starter.job.auto.config.MisfireStrategyEnum;
import plus.easydo.starter.job.auto.config.RouteStrategyEnum;
import plus.easydo.starter.job.auto.config.ScheduleTypeEnum;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author RaoYuan
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
@Documented
public @interface AutoRegister {
    /**r任务详细*/
    String desc();
    /**调度配置参数*/
    String scheduleConf() default "";
    /**调度类型*/
    ScheduleTypeEnum scheduleType() default ScheduleTypeEnum.CRON;
    /**负责人*/
    String author();
    /**执行器路由策略*/
    RouteStrategyEnum executorRouteStrategy() default RouteStrategyEnum.FIRST;
    /**任务ID*/
    String childJobId() default "";
    /**阻塞处理策略*/
    BlockStrategy executorBlockStrategy() default BlockStrategy.SERIAL_EXECUTION;
    /**运行模式*/
    GlueTypeEnum glueType() default GlueTypeEnum.BEAN;
    /**超时时间*/
    int executorTimeout() default 0;
    /**失败重试次数*/
    int executorFailRetryCount() default 0;
    /**任务参数*/
    String executorParam() default "";
    /**GLUE备注*/
    String glueRemark() default "GLUE代码初始化";
    /**GLUE源码（命令行、java等调度方式使用）*/
    String glueSource() default "";
    /**报警接收的邮箱*/
    String alarmEmail() default "";
    /**调度过期策略*/
    MisfireStrategyEnum misfireStrategy() default MisfireStrategyEnum.DO_NOTHING;
}
