package plus.easydo.starter.job.auto.call;



import plus.easydo.starter.job.auto.model.ExecutorInfo;
import plus.easydo.starter.job.auto.model.SchedulerInfo;

import java.util.List;

/**
 * 远程调用接口
 * @author RaoYuan
 */
public interface RemoteCall {

    /**
     * 获取登录后的cookie
     *
     * @param address xxl-job地址
     * @param username 用户名
     * @param password 密码
     * @return cookie
     */
    String getCookie(String address, String username, String password);

    /**
     * 获取执行器列表
     *
     * @param cookie cookie
     * @param address 地址
     * @param appname 执行器名称
     * @return List
     */
    List<ExecutorInfo> executorList(String cookie, String address, String appname);

    /**
     * 执行器注册
     *
     * @param cookie 请求头
     * @param address 地址
     * @param executorInfo 请求参数
     */
    void executorRegister(String cookie, String address, ExecutorInfo executorInfo);

    /**
     * 获取对应执行器下的调度器列表
     *
     * @param cookie 请求头
     * @param address 地址
     * @param jobGroup 执行器ID
     * @return List
     */
    List<SchedulerInfo> schedulerList(String cookie, String address, Integer jobGroup);

    /**
     * 调度器列注册
     *
     * @param cookie 请求cookie
     * @param address 地址
     * @param schedulerInfo 调度器信息
     */
    void schedulerRegister(String cookie, String address, SchedulerInfo schedulerInfo);
}
