package plus.easydo.starter.job.auto.config;

/**
 * 阻塞处理策略
 * @author RaoYuan
 */
public enum BlockStrategy {
    /**
     * 单机串行
     */
    SERIAL_EXECUTION("SERIAL_EXECUTION", "单机串行"),
    /**
     * 丢弃后续调度
     */
    DISCARD_LATER("DISCARD_LATER", "丢弃后续调度"),
    /**
     * 覆盖之前调度
     */
    COVER_EARLY("COVER_EARLY", "覆盖之前调度");

    private final String strategy;
    private final String desc;

    BlockStrategy(String strategy, String desc) {
        this.strategy = strategy;
        this.desc = desc;
    }

    public String getStrategy() {
        return strategy;
    }

    public String getDesc() {
        return desc;
    }
}
