package plus.easydo.starter.job.auto.config;

/**
 * 执行器路由策略
 * @author RaoYuan
 */
public enum RouteStrategyEnum {

    /*路由策略*/
    FIRST("FIRST", "第一个"),
    LAST("LAST", "最后一个"),
    ROUND("ROUND", "轮询"),
    RANDOM("RANDOM", "随机"),
    CONSISTENT_HASH("CONSISTENT_HASH", "一致性HASH"),
    LEAST_FREQUENTLY_USED("LEAST_FREQUENTLY_USED", "最不经常使用"),
    LEAST_RECENTLY_USED("LEAST_RECENTLY_USED", "最近最久未使用"),
    FAILOVER("FAILOVER", "故障转移"),
    BUSY_OVER("BUSYOVER", "忙碌转移"),
    SHARDING_BROADCAST("SHARDING_BROADCAST", "分片广播");

    private final String strategy;
    private final String desc;

    RouteStrategyEnum(String strategy, String desc) {
        this.strategy = strategy;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public String getStrategy(){
        return strategy;
    }
}
