/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.job.auto.call;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import plus.easydo.core.exception.BaseException;
import plus.easydo.starter.job.auto.call.RemoteCall;
import plus.easydo.starter.job.auto.model.ExecutorInfo;
import plus.easydo.starter.job.auto.model.SchedulerInfo;

@Configuration
public class RemoteCallService
implements RemoteCall {
    private static final Logger log = LoggerFactory.getLogger(RemoteCallService.class);
    private static final String COOKIE = "Cookie";
    private static final String LOGIN = "/login";
    private static final String EXECUTOR_LIST_PATH = "/jobgroup/save";
    private static final String EXECUTOR_REGISTER_PATH = "/jobgroup/pageList";
    private static final String SCHEDULER_LIST_PATH = "/jobinfo/pageList";
    private static final String SCHEDULER_REGISTER_PATH = "/jobinfo/add";
    private static final int SUCCESS_CODE = 200;
    private static final RestTemplate REST_TEMPLATE = new RestTemplate();

    @Override
    public String getCookie(String address, String username, String password) {
        try {
            ResponseEntity responseEntity = REST_TEMPLATE.postForEntity(address + LOGIN + "?userName=" + username + "&password=" + password, null, String.class, new Object[0]);
            JSONObject loginResponseBody = JSON.parseObject((String)((String)responseEntity.getBody()));
            Integer code = loginResponseBody.getInteger("code");
            Assert.isTrue((code == 200 ? 1 : 0) != 0, (String)loginResponseBody.getString("msg"));
            HttpHeaders headers = responseEntity.getHeaders();
            log.debug("headers:{}", (Object)headers);
            List headerList = headers.get((Object)"Set-Cookie");
            assert (null != headerList && !headerList.isEmpty());
            return ((String)headerList.get(0)).split(";")[0];
        }
        catch (Exception e) {
            log.warn("xxl-job\u767b\u5f55\u5f02\u5e38,{}", (Object)e.getMessage());
            throw new BaseException("xxl-job\u767b\u5f55\u5f02\u5e38:" + e.getMessage());
        }
    }

    @Override
    public List<ExecutorInfo> executorList(String cookie, String address, String appname) {
        try {
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            if (StrUtil.isNotBlank((CharSequence)appname)) {
                params.add((Object)"appname", (Object)appname);
            }
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.set(COOKIE, cookie);
            return this.list(address + EXECUTOR_REGISTER_PATH, httpHeaders, (MultiValueMap<Object, Object>)params, ExecutorInfo.class);
        }
        catch (Exception e) {
            log.warn("xxl-job\u6267\u884c\u5668\u5217\u8868\u67e5\u8be2\u5f02\u5e38,{}", (Object)e.getMessage());
            throw new BaseException("xxl-job\u6267\u884c\u5668\u5217\u8868\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
    }

    @Override
    public void executorRegister(String cookie, String address, ExecutorInfo executorInfo) {
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.set(COOKIE, cookie);
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.add((Object)"appname", (Object)executorInfo.getAppname());
            params.add((Object)"title", (Object)executorInfo.getTitle());
            params.add((Object)"addressType", (Object)executorInfo.getAddressType());
            this.registerResCheck(address + EXECUTOR_LIST_PATH, httpHeaders, (MultiValueMap<Object, Object>)params);
        }
        catch (Exception e) {
            log.warn("xxl-job\u6267\u884c\u5668\u81ea\u52a8\u6ce8\u518c\u5f02\u5e38,{}", (Object)e.getMessage());
            throw new BaseException("\u6267\u884c\u5668\u81ea\u52a8\u6ce8\u518c\u5f02\u5e38:" + e.getMessage());
        }
    }

    @Override
    public List<SchedulerInfo> schedulerList(String cookie, String address, Integer jobGroup) {
        try {
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            if (!Objects.isNull(jobGroup)) {
                params.add((Object)"jobGroup", (Object)jobGroup);
            }
            params.add((Object)"triggerStatus", (Object)-1);
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.set(COOKIE, cookie);
            return this.list(address + SCHEDULER_LIST_PATH, httpHeaders, (MultiValueMap<Object, Object>)params, SchedulerInfo.class);
        }
        catch (Exception e) {
            log.warn("xxl-job\u8c03\u5ea6\u5668\u5217\u8868\u83b7\u53d6\u5f02\u5e38,{}", (Object)e.getMessage());
            throw new BaseException("\u8c03\u5ea6\u5668\u5217\u8868\u83b7\u53d6\u5f02\u5e38:" + e.getMessage());
        }
    }

    @Override
    public void schedulerRegister(String cookie, String address, SchedulerInfo schedulerInfo) {
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.set(COOKIE, cookie);
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.add((Object)"jobGroup", (Object)schedulerInfo.getJobGroup());
            params.add((Object)"scheduleType", (Object)schedulerInfo.getScheduleType());
            params.add((Object)"scheduleConf", (Object)schedulerInfo.getScheduleConf());
            params.add((Object)"cronGen_display", (Object)schedulerInfo.getCronGenDisplay());
            params.add((Object)"schedule_conf_CRON", (Object)schedulerInfo.getScheduleConfCron());
            params.add((Object)"schedule_conf_FIX_RATE", (Object)schedulerInfo.getScheduleConfFixRate());
            params.add((Object)"schedule_conf_FIX_DELAY", (Object)schedulerInfo.getScheduleConfFixDelay());
            params.add((Object)"jobDesc", (Object)schedulerInfo.getJobDesc());
            params.add((Object)"author", (Object)schedulerInfo.getAuthor());
            params.add((Object)"alarmEmail", (Object)schedulerInfo.getAlarmEmail());
            params.add((Object)"executorRouteStrategy", (Object)schedulerInfo.getExecutorRouteStrategy());
            params.add((Object)"executorHandler", (Object)schedulerInfo.getExecutorHandler());
            params.add((Object)"executorParam", (Object)schedulerInfo.getExecutorParam());
            params.add((Object)"executorBlockStrategy", (Object)schedulerInfo.getExecutorBlockStrategy());
            params.add((Object)"executorTimeout", (Object)schedulerInfo.getExecutorTimeout());
            params.add((Object)"executorFailRetryCount", (Object)schedulerInfo.getExecutorFailRetryCount());
            params.add((Object)"misfireStrategy", (Object)schedulerInfo.getMisfireStrategy());
            params.add((Object)"glueType", (Object)schedulerInfo.getGlueType());
            params.add((Object)"glueSource", (Object)schedulerInfo.getGlueSource());
            params.add((Object)"glueRemark", (Object)schedulerInfo.getGlueRemark());
            this.registerResCheck(address + SCHEDULER_REGISTER_PATH, httpHeaders, (MultiValueMap<Object, Object>)params);
        }
        catch (Exception e) {
            log.warn("xxl-job\u8c03\u5ea6\u5668\u81ea\u52a8\u6ce8\u518c\u5f02\u5e38,{}", (Object)e.getMessage());
            throw new BaseException("\u8c03\u5ea6\u5668\u81ea\u52a8\u6ce8\u518c\u5f02\u5e38:" + e.getMessage());
        }
    }

    private <T> List<T> list(String url, HttpHeaders httpHeaders, MultiValueMap<Object, Object> params, Class<T> type) {
        HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)httpHeaders);
        ResponseEntity responseEntity = REST_TEMPLATE.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        JSONObject response = JSON.parseObject((String)((String)responseEntity.getBody()));
        JSONArray executorList = response.getJSONArray("data");
        return JSON.parseArray((String)executorList.toJSONString(), type);
    }

    private void registerResCheck(String url, HttpHeaders httpHeaders, MultiValueMap<Object, Object> params) {
        HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)httpHeaders);
        ResponseEntity responseEntity = REST_TEMPLATE.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        log.debug("register response:{}", responseEntity.getBody());
        JSONObject saveResponseBody = JSON.parseObject((String)((String)responseEntity.getBody()));
        Assert.isTrue((saveResponseBody.getInteger("code") == 200 ? 1 : 0) != 0, (String)saveResponseBody.getString("msg"));
    }
}

