/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.job.auto.config;

import cn.hutool.core.util.StrUtil;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import plus.easydo.core.exception.BaseException;
import plus.easydo.starter.job.auto.annotion.AutoRegister;
import plus.easydo.starter.job.auto.call.RemoteCall;
import plus.easydo.starter.job.auto.config.ScheduleTypeEnum;
import plus.easydo.starter.job.auto.model.ExecutorInfo;
import plus.easydo.starter.job.auto.model.SchedulerInfo;

@Configuration
public class AutoRegisterConfig
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(AutoRegisterConfig.class);
    @Autowired
    private RemoteCall remoteCall;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${xxl.job.admin.addresses}")
    private String address;
    @Value(value="${xxl.job.executor.appname}")
    private String appname;
    @Value(value="${xxl.job.executor.title:}")
    private String title;
    @Value(value="${xxl.job.admin.username:}")
    private String username;
    @Value(value="${xxl.job.admin.password:}")
    private String password;

    public void run(String ... args) throws Exception {
        String[] beanDefinitionNames;
        HashMap<XxlJob, AutoRegister> map = new HashMap<XxlJob, AutoRegister>(4);
        for (String beanDefinitionName : beanDefinitionNames = this.applicationContext.getBeanNamesForType(Object.class, false, true)) {
            Map annotatedScheduler;
            Map annotatedJob;
            Object bean = this.applicationContext.getBean(beanDefinitionName);
            try {
                annotatedJob = MethodIntrospector.selectMethods(bean.getClass(), method -> (XxlJob)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, XxlJob.class));
                annotatedScheduler = MethodIntrospector.selectMethods(bean.getClass(), method -> (AutoRegister)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, AutoRegister.class));
            }
            catch (Exception ex) {
                log.warn("xxl-job auto register resolve error for bean[{}].", (Object)beanDefinitionName, (Object)ex);
                log.warn("[{}]\u7c7b\u83b7\u53d6\u6ce8\u89e3\u5f02\u5e38, \u505c\u6b62\u81ea\u52a8\u6dfb\u52a0\u6267\u884c\u5668\u548c\u8c03\u5ea6\u5668", (Object)beanDefinitionName);
                return;
            }
            for (Map.Entry methodAutoSchedulerEntry : annotatedScheduler.entrySet()) {
                Method method2 = (Method)methodAutoSchedulerEntry.getKey();
                AutoRegister autoRegister = (AutoRegister)methodAutoSchedulerEntry.getValue();
                XxlJob xxlJob = (XxlJob)annotatedJob.get(method2);
                if (Objects.isNull(xxlJob)) {
                    log.warn("[{}]\u7c7b\u4e2d\u6ca1\u6709\u6dfb\u52a0XxlJob\u6ce8\u89e3,\u4e0d\u80fd\u5c06\u5176\u6dfb\u52a0\u8c03\u5ea6\u5668", (Object)beanDefinitionName);
                    continue;
                }
                map.put(xxlJob, autoRegister);
            }
        }
        this.registerCheck(map);
    }

    private void registerCheck(Map<XxlJob, AutoRegister> map) {
        if (map.isEmpty()) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)this.username) || StrUtil.isBlank((CharSequence)this.password)) {
            log.warn("xxl-job\u8d26\u53f7\u6216\u5bc6\u7801\u4e3a\u7a7a,\u505c\u6b62\u81ea\u52a8\u6dfb\u52a0\u6267\u884c\u5668\u548c\u8c03\u5ea6\u5668");
            return;
        }
        if (StrUtil.isBlank((CharSequence)this.title)) {
            log.warn("xxl-job\u6267\u884c\u5668\u540d\u79f0\u4e3a\u7a7a,\u505c\u6b62\u81ea\u52a8\u6dfb\u52a0\u6267\u884c\u5668\u548c\u8c03\u5ea6\u5668");
            return;
        }
        try {
            this.registerExecutor(map);
        }
        catch (Exception e) {
            log.warn("xxl-job\u81ea\u52a8\u6dfb\u52a0\u5f02\u5e38,\u505c\u6b62\u81ea\u52a8\u6dfb\u52a0", (Throwable)e);
        }
    }

    private void registerExecutor(Map<XxlJob, AutoRegister> map) {
        String cookie = this.remoteCall.getCookie(this.address, this.username, this.password);
        List<ExecutorInfo> executorInfos = this.remoteCall.executorList(cookie, this.address, this.appname);
        if (executorInfos.size() > 1) {
            log.warn("xxl-job\u4e2d\u5b58\u5728\u591a\u4e2a[{}]\u6267\u884c\u5668,\u5df2\u505c\u6b62\u81ea\u52a8\u6ce8\u518c\u529f\u80fd", (Object)this.appname);
            return;
        }
        if (executorInfos.size() == 1) {
            log.info("++++++++++[{}]\u6267\u884c\u5668\u5df2\u5b58\u5728++++++++++", (Object)this.appname);
        } else {
            ExecutorInfo executorInfo = new ExecutorInfo();
            executorInfo.setAppname(this.appname);
            executorInfo.setTitle(this.title);
            executorInfo.setAddressType(0);
            this.remoteCall.executorRegister(cookie, this.address, executorInfo);
            log.info("++++++++++[{}]\u6267\u884c\u5668\u6dfb\u52a0\u6210\u529f++++++++++", (Object)this.appname);
        }
        this.registerScheduler(cookie, executorInfos, map);
    }

    private void registerScheduler(String cookie, List<ExecutorInfo> executorInfos, Map<XxlJob, AutoRegister> map) {
        int jobGroup;
        if (executorInfos.size() == 1) {
            jobGroup = executorInfos.get(0).getId();
        } else {
            executorInfos = this.remoteCall.executorList(cookie, this.address, this.appname);
            if (executorInfos.size() > 1) {
                log.warn("xxl-job\u4e2d\u5b58\u5728\u591a\u4e2a[{}]\u6267\u884c\u5668,\u5df2\u505c\u6b62\u81ea\u52a8\u6ce8\u518c\u529f\u80fd", (Object)this.appname);
                return;
            }
            if (executorInfos.isEmpty()) {
                log.warn("[{}]\u6267\u884c\u5668\u6ce8\u518c\u5f02\u5e38,\u672a\u83b7\u53d6\u5230\u4e0a\u6587\u6240\u6ce8\u518c\u7684\u6267\u884c\u5668", (Object)this.appname);
                throw new BaseException("500", this.appname + "\u6267\u884c\u5668\u81ea\u52a8\u6ce8\u518c\u5f02\u5e38, \u672a\u83b7\u53d6\u5230\u4e0a\u6587\u6240\u6ce8\u518c\u7684\u6267\u884c\u5668");
            }
            jobGroup = executorInfos.get(0).getId();
        }
        List<SchedulerInfo> schedulerInfos = this.remoteCall.schedulerList(cookie, this.address, jobGroup);
        List executorHandlerList = schedulerInfos.stream().map(SchedulerInfo::getExecutorHandler).collect(Collectors.toList());
        for (Map.Entry<XxlJob, AutoRegister> xxlJobAutoRegisterEntry : map.entrySet()) {
            XxlJob xxlJob = xxlJobAutoRegisterEntry.getKey();
            String executorHandler = xxlJob.value();
            if (executorHandlerList.contains(executorHandler)) {
                log.info("++++++++++[{}]\u8c03\u5ea6\u5668\u5df2\u5b58\u5728++++++++++", (Object)executorHandler);
                continue;
            }
            AutoRegister autoRegister = xxlJobAutoRegisterEntry.getValue();
            SchedulerInfo schedulerInfo = new SchedulerInfo();
            schedulerInfo.setJobGroup(jobGroup);
            schedulerInfo.setJobDesc(autoRegister.desc());
            schedulerInfo.setExecutorHandler(executorHandler);
            schedulerInfo.setAlarmEmail(autoRegister.alarmEmail());
            schedulerInfo.setAuthor(autoRegister.author());
            schedulerInfo.setChildJobId(autoRegister.childJobId());
            schedulerInfo.setExecutorBlockStrategy(autoRegister.executorBlockStrategy().getStrategy());
            schedulerInfo.setExecutorRouteStrategy(autoRegister.executorRouteStrategy().getStrategy());
            schedulerInfo.setGlueType(autoRegister.glueType().getCode());
            schedulerInfo.setExecutorTimeout(autoRegister.executorTimeout());
            schedulerInfo.setExecutorFailRetryCount(autoRegister.executorFailRetryCount());
            schedulerInfo.setExecutorParam(autoRegister.executorParam());
            schedulerInfo.setGlueRemark(autoRegister.glueRemark());
            schedulerInfo.setGlueSource(autoRegister.glueSource());
            schedulerInfo.setMisfireStrategy(autoRegister.misfireStrategy().getCode());
            this.generateSchedulerConfig(autoRegister, schedulerInfo);
            log.debug("SchedulerInfo:{}", (Object)schedulerInfo);
            this.remoteCall.schedulerRegister(cookie, this.address, schedulerInfo);
            log.info("++++++++++[{}]\u8c03\u5ea6\u5668\u6dfb\u52a0\u5b8c\u6210++++++++++", (Object)executorHandler);
        }
    }

    private void generateSchedulerConfig(AutoRegister autoRegister, SchedulerInfo schedulerInfo) {
        String scheduleType = autoRegister.scheduleType().getType();
        schedulerInfo.setScheduleType(autoRegister.scheduleType().getType());
        if (scheduleType.equals(ScheduleTypeEnum.CRON.getType())) {
            schedulerInfo.setScheduleConf(autoRegister.scheduleConf());
            schedulerInfo.setScheduleConfCron(autoRegister.scheduleConf());
            schedulerInfo.setCronGenDisplay(autoRegister.scheduleConf());
        }
        if (scheduleType.equals(ScheduleTypeEnum.FIX_RATE.getType())) {
            schedulerInfo.setScheduleConf(autoRegister.scheduleConf());
            schedulerInfo.setScheduleConfFixRate(autoRegister.scheduleConf());
            schedulerInfo.setScheduleConfFixDelay(autoRegister.scheduleConf());
        }
    }
}

