/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.monitor.sdk.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.util.Arrays;
import plus.gaga.monitor.sdk.model.LogMessage;
import plus.gaga.monitor.sdk.push.IPush;
import plus.gaga.monitor.sdk.push.impl.RedisPush;

public class CustomAppender<E>
extends AppenderBase<E> {
    private String systemName;
    private String groupId;
    private String host;
    private int port;
    private final IPush push = new RedisPush();

    protected void append(E eventObject) {
        this.push.open(this.host, this.port);
        if (eventObject instanceof ILoggingEvent) {
            ILoggingEvent event = (ILoggingEvent)eventObject;
            String methodName = "unknown";
            String className = "unknown";
            StackTraceElement[] callerDataArray = event.getCallerData();
            if (callerDataArray != null && callerDataArray.length > 0) {
                StackTraceElement callerData = callerDataArray[0];
                methodName = callerData.getMethodName();
                className = callerData.getClassName();
            }
            if (!className.startsWith(this.groupId)) {
                return;
            }
            LogMessage logMessage = new LogMessage(this.systemName, className, methodName, Arrays.asList(event.getFormattedMessage().split(" ")));
            this.push.send(logMessage);
        }
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public IPush getPush() {
        return this.push;
    }
}

