/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.chatglm.model;

import com.alibaba.fastjson2.JSON;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class ChatCompletionResponse {
    private String data;
    private String meta;
    private String id;
    private Long created;
    private String model;
    private List<Choice> choices;
    private Usage usage;

    public void setChoices(List<Choice> choices) {
        this.choices = choices;
        for (Choice choice : choices) {
            if ("stop".equals(choice.finishReason)) continue;
            if (null == this.data) {
                this.data = "";
            }
            this.data = this.data.concat(choice.getDelta().getContent());
        }
    }

    public void setUsage(Usage usage) {
        this.usage = usage;
        if (null != usage) {
            this.meta = JSON.toJSONString((Object)Meta.builder().usage(usage).build());
        }
    }

    public String getData() {
        return this.data;
    }

    public String getMeta() {
        return this.meta;
    }

    public String getId() {
        return this.id;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getModel() {
        return this.model;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setMeta(String meta) {
        this.meta = meta;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletionResponse)) {
            return false;
        }
        ChatCompletionResponse other = (ChatCompletionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$meta = this.getMeta();
        String other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !this$meta.equals(other$meta)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<Choice> this$choices = this.getChoices();
        List<Choice> other$choices = other.getChoices();
        if (this$choices == null ? other$choices != null : !((Object)this$choices).equals(other$choices)) {
            return false;
        }
        Usage this$usage = this.getUsage();
        Usage other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletionResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : $meta.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<Choice> $choices = this.getChoices();
        result = result * 59 + ($choices == null ? 43 : ((Object)$choices).hashCode());
        Usage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        return result;
    }

    public String toString() {
        return "ChatCompletionResponse(data=" + this.getData() + ", meta=" + this.getMeta() + ", id=" + this.getId() + ", created=" + this.getCreated() + ", model=" + this.getModel() + ", choices=" + this.getChoices() + ", usage=" + this.getUsage() + ")";
    }

    public static class Usage {
        private int completion_tokens;
        private int prompt_tokens;
        private int total_tokens;

        public int getCompletion_tokens() {
            return this.completion_tokens;
        }

        public int getPrompt_tokens() {
            return this.prompt_tokens;
        }

        public int getTotal_tokens() {
            return this.total_tokens;
        }

        public void setCompletion_tokens(int completion_tokens) {
            this.completion_tokens = completion_tokens;
        }

        public void setPrompt_tokens(int prompt_tokens) {
            this.prompt_tokens = prompt_tokens;
        }

        public void setTotal_tokens(int total_tokens) {
            this.total_tokens = total_tokens;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Usage)) {
                return false;
            }
            Usage other = (Usage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCompletion_tokens() != other.getCompletion_tokens()) {
                return false;
            }
            if (this.getPrompt_tokens() != other.getPrompt_tokens()) {
                return false;
            }
            return this.getTotal_tokens() == other.getTotal_tokens();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Usage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCompletion_tokens();
            result = result * 59 + this.getPrompt_tokens();
            result = result * 59 + this.getTotal_tokens();
            return result;
        }

        public String toString() {
            return "ChatCompletionResponse.Usage(completion_tokens=" + this.getCompletion_tokens() + ", prompt_tokens=" + this.getPrompt_tokens() + ", total_tokens=" + this.getTotal_tokens() + ")";
        }
    }

    public static class Meta {
        private String task_status;
        private Usage usage;
        private String task_id;
        private String request_id;

        public static MetaBuilder builder() {
            return new MetaBuilder();
        }

        public String getTask_status() {
            return this.task_status;
        }

        public Usage getUsage() {
            return this.usage;
        }

        public String getTask_id() {
            return this.task_id;
        }

        public String getRequest_id() {
            return this.request_id;
        }

        public void setTask_status(String task_status) {
            this.task_status = task_status;
        }

        public void setUsage(Usage usage) {
            this.usage = usage;
        }

        public void setTask_id(String task_id) {
            this.task_id = task_id;
        }

        public void setRequest_id(String request_id) {
            this.request_id = request_id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Meta)) {
                return false;
            }
            Meta other = (Meta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$task_status = this.getTask_status();
            String other$task_status = other.getTask_status();
            if (this$task_status == null ? other$task_status != null : !this$task_status.equals(other$task_status)) {
                return false;
            }
            Usage this$usage = this.getUsage();
            Usage other$usage = other.getUsage();
            if (this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage)) {
                return false;
            }
            String this$task_id = this.getTask_id();
            String other$task_id = other.getTask_id();
            if (this$task_id == null ? other$task_id != null : !this$task_id.equals(other$task_id)) {
                return false;
            }
            String this$request_id = this.getRequest_id();
            String other$request_id = other.getRequest_id();
            return !(this$request_id == null ? other$request_id != null : !this$request_id.equals(other$request_id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Meta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $task_status = this.getTask_status();
            result = result * 59 + ($task_status == null ? 43 : $task_status.hashCode());
            Usage $usage = this.getUsage();
            result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
            String $task_id = this.getTask_id();
            result = result * 59 + ($task_id == null ? 43 : $task_id.hashCode());
            String $request_id = this.getRequest_id();
            result = result * 59 + ($request_id == null ? 43 : $request_id.hashCode());
            return result;
        }

        public String toString() {
            return "ChatCompletionResponse.Meta(task_status=" + this.getTask_status() + ", usage=" + this.getUsage() + ", task_id=" + this.getTask_id() + ", request_id=" + this.getRequest_id() + ")";
        }

        public Meta() {
        }

        public Meta(String task_status, Usage usage, String task_id, String request_id) {
            this.task_status = task_status;
            this.usage = usage;
            this.task_id = task_id;
            this.request_id = request_id;
        }

        public static class MetaBuilder {
            private String task_status;
            private Usage usage;
            private String task_id;
            private String request_id;

            MetaBuilder() {
            }

            public MetaBuilder task_status(String task_status) {
                this.task_status = task_status;
                return this;
            }

            public MetaBuilder usage(Usage usage) {
                this.usage = usage;
                return this;
            }

            public MetaBuilder task_id(String task_id) {
                this.task_id = task_id;
                return this;
            }

            public MetaBuilder request_id(String request_id) {
                this.request_id = request_id;
                return this;
            }

            public Meta build() {
                return new Meta(this.task_status, this.usage, this.task_id, this.request_id);
            }

            public String toString() {
                return "ChatCompletionResponse.Meta.MetaBuilder(task_status=" + this.task_status + ", usage=" + this.usage + ", task_id=" + this.task_id + ", request_id=" + this.request_id + ")";
            }
        }
    }

    public static class Delta {
        private String role;
        private String content;

        public String getRole() {
            return this.role;
        }

        public String getContent() {
            return this.content;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Delta)) {
                return false;
            }
            Delta other = (Delta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Delta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        public String toString() {
            return "ChatCompletionResponse.Delta(role=" + this.getRole() + ", content=" + this.getContent() + ")";
        }
    }

    public static class Choice {
        private Long index;
        @JsonProperty(value="finish_reason")
        private String finishReason;
        private Delta delta;

        public Long getIndex() {
            return this.index;
        }

        public String getFinishReason() {
            return this.finishReason;
        }

        public Delta getDelta() {
            return this.delta;
        }

        public void setIndex(Long index) {
            this.index = index;
        }

        @JsonProperty(value="finish_reason")
        public void setFinishReason(String finishReason) {
            this.finishReason = finishReason;
        }

        public void setDelta(Delta delta) {
            this.delta = delta;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Choice)) {
                return false;
            }
            Choice other = (Choice)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$index = this.getIndex();
            Long other$index = other.getIndex();
            if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
                return false;
            }
            String this$finishReason = this.getFinishReason();
            String other$finishReason = other.getFinishReason();
            if (this$finishReason == null ? other$finishReason != null : !this$finishReason.equals(other$finishReason)) {
                return false;
            }
            Delta this$delta = this.getDelta();
            Delta other$delta = other.getDelta();
            return !(this$delta == null ? other$delta != null : !((Object)this$delta).equals(other$delta));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Choice;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $index = this.getIndex();
            result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
            String $finishReason = this.getFinishReason();
            result = result * 59 + ($finishReason == null ? 43 : $finishReason.hashCode());
            Delta $delta = this.getDelta();
            result = result * 59 + ($delta == null ? 43 : ((Object)$delta).hashCode());
            return result;
        }

        public String toString() {
            return "ChatCompletionResponse.Choice(index=" + this.getIndex() + ", finishReason=" + this.getFinishReason() + ", delta=" + this.getDelta() + ")";
        }
    }
}

