/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.chatgpt;

import io.reactivex.Single;
import java.io.File;
import java.time.LocalDate;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import plus.gaga.middleware.chatgpt.domain.billing.BillingUsage;
import plus.gaga.middleware.chatgpt.domain.billing.Subscription;
import plus.gaga.middleware.chatgpt.domain.chat.ChatCompletionRequest;
import plus.gaga.middleware.chatgpt.domain.chat.ChatCompletionResponse;
import plus.gaga.middleware.chatgpt.domain.edits.EditRequest;
import plus.gaga.middleware.chatgpt.domain.edits.EditResponse;
import plus.gaga.middleware.chatgpt.domain.embedd.EmbeddingRequest;
import plus.gaga.middleware.chatgpt.domain.embedd.EmbeddingResponse;
import plus.gaga.middleware.chatgpt.domain.files.DeleteFileResponse;
import plus.gaga.middleware.chatgpt.domain.files.UploadFileResponse;
import plus.gaga.middleware.chatgpt.domain.images.ImageRequest;
import plus.gaga.middleware.chatgpt.domain.images.ImageResponse;
import plus.gaga.middleware.chatgpt.domain.other.OpenAiResponse;
import plus.gaga.middleware.chatgpt.domain.qa.QACompletionRequest;
import plus.gaga.middleware.chatgpt.domain.qa.QACompletionResponse;
import plus.gaga.middleware.chatgpt.domain.vision.VisionCompletionRequest;
import plus.gaga.middleware.chatgpt.domain.vision.VisionCompletionResponse;
import plus.gaga.middleware.chatgpt.domain.whisper.WhisperResponse;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.PartMap;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Streaming;

public interface IOpenAiApi {
    public static final String v1_completions = "v1/completions";
    public static final String v1_chat_completions = "v1/chat/completions";
    public static final String v1_images_completions = "v1/images/generations";

    @POST(value="v1/completions")
    public Single<QACompletionResponse> completions(@Body QACompletionRequest var1);

    @POST(value="v1/chat/completions")
    public Single<ChatCompletionResponse> completions(@Body ChatCompletionRequest var1);

    @POST(value="v1/chat/completions")
    public Single<VisionCompletionResponse> completions(@Body VisionCompletionRequest var1);

    @POST(value="v1/edits")
    public Single<EditResponse> edits(@Body EditRequest var1);

    @POST(value="v1/images/generations")
    public Single<ImageResponse> genImages(@Body ImageRequest var1);

    @Multipart
    @POST(value="v1/images/edits")
    public Single<ImageResponse> editImages(@Part MultipartBody.Part var1, @Part MultipartBody.Part var2, @PartMap Map<String, RequestBody> var3);

    @POST(value="v1/embeddings")
    public Single<EmbeddingResponse> embeddings(@Body EmbeddingRequest var1);

    @GET(value="v1/files")
    public Single<OpenAiResponse<File>> files();

    @Multipart
    @POST(value="v1/files")
    public Single<UploadFileResponse> uploadFile(@Part MultipartBody.Part var1, @Part(value="purpose") RequestBody var2);

    @DELETE(value="v1/files/{file_id}")
    public Single<DeleteFileResponse> deleteFile(@Path(value="file_id") String var1);

    @GET(value="v1/files/{file_id}")
    public Single<File> retrieveFile(@Path(value="file_id") String var1);

    @Streaming
    @GET(value="v1/files/{file_id}/content")
    public Single<ResponseBody> retrieveFileContent(@Path(value="file_id") String var1);

    @Multipart
    @POST(value="v1/audio/transcriptions")
    public Single<WhisperResponse> speed2TextTranscriptions(@Part MultipartBody.Part var1, @PartMap Map<String, RequestBody> var2);

    @Multipart
    @POST(value="v1/audio/translations")
    public Single<WhisperResponse> speed2TextTranslations(@Part MultipartBody.Part var1, @PartMap Map<String, RequestBody> var2);

    @GET(value="v1/dashboard/billing/subscription")
    public Single<Subscription> subscription();

    @GET(value="v1/dashboard/billing/usage")
    public Single<BillingUsage> billingUsage(@Query(value="start_date") LocalDate var1, @Query(value="end_date") LocalDate var2);
}

