/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.chatgpt.domain.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.gaga.middleware.chatgpt.domain.chat.Message;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChatCompletionRequest
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ChatCompletionRequest.class);
    private String model = Model.GPT_3_5_TURBO.getCode();
    private List<Message> messages;
    private double temperature = 0.2;
    @JsonProperty(value="top_p")
    private Double topP = 1.0;
    private Integer n = 1;
    private boolean stream = false;
    private List<String> stop;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens = 2048;
    @JsonProperty(value="frequency_penalty")
    private double frequencyPenalty = 0.0;
    @JsonProperty(value="presence_penalty")
    private double presencePenalty = 0.0;
    @JsonProperty(value="logit_bias")
    private Map logitBias;
    private String user;

    public static ChatCompletionRequestBuilder builder() {
        return new ChatCompletionRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public boolean isStream() {
        return this.stream;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Map getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="logit_bias")
    public void setLogitBias(Map logitBias) {
        this.logitBias = logitBias;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletionRequest)) {
            return false;
        }
        ChatCompletionRequest other = (ChatCompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (Double.compare(this.getFrequencyPenalty(), other.getFrequencyPenalty()) != 0) {
            return false;
        }
        if (Double.compare(this.getPresencePenalty(), other.getPresencePenalty()) != 0) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map this$logitBias = this.getLogitBias();
        Map other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        result = result * 59 + (this.isStream() ? 79 : 97);
        long $frequencyPenalty = Double.doubleToLongBits(this.getFrequencyPenalty());
        result = result * 59 + (int)($frequencyPenalty >>> 32 ^ $frequencyPenalty);
        long $presencePenalty = Double.doubleToLongBits(this.getPresencePenalty());
        result = result * 59 + (int)($presencePenalty >>> 32 ^ $presencePenalty);
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "ChatCompletionRequest(model=" + this.getModel() + ", messages=" + this.getMessages() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", n=" + this.getN() + ", stream=" + this.isStream() + ", stop=" + this.getStop() + ", maxTokens=" + this.getMaxTokens() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", presencePenalty=" + this.getPresencePenalty() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ")";
    }

    public ChatCompletionRequest() {
    }

    public ChatCompletionRequest(String model, List<Message> messages, double temperature, Double topP, Integer n, boolean stream, List<String> stop, Integer maxTokens, double frequencyPenalty, double presencePenalty, Map logitBias, String user) {
        this.model = model;
        this.messages = messages;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.logitBias = logitBias;
        this.user = user;
    }

    public static class ChatCompletionRequestBuilder {
        private String model;
        private List<Message> messages;
        private double temperature;
        private Double topP;
        private Integer n;
        private boolean stream;
        private List<String> stop;
        private Integer maxTokens;
        private double frequencyPenalty;
        private double presencePenalty;
        private Map logitBias;
        private String user;

        ChatCompletionRequestBuilder() {
        }

        public ChatCompletionRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ChatCompletionRequestBuilder messages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        public ChatCompletionRequestBuilder temperature(double temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="top_p")
        public ChatCompletionRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ChatCompletionRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public ChatCompletionRequestBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public ChatCompletionRequestBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public ChatCompletionRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public ChatCompletionRequestBuilder frequencyPenalty(double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public ChatCompletionRequestBuilder presencePenalty(double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public ChatCompletionRequestBuilder logitBias(Map logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public ChatCompletionRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ChatCompletionRequest build() {
            return new ChatCompletionRequest(this.model, this.messages, this.temperature, this.topP, this.n, this.stream, this.stop, this.maxTokens, this.frequencyPenalty, this.presencePenalty, this.logitBias, this.user);
        }

        public String toString() {
            return "ChatCompletionRequest.ChatCompletionRequestBuilder(model=" + this.model + ", messages=" + this.messages + ", temperature=" + this.temperature + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", stop=" + this.stop + ", maxTokens=" + this.maxTokens + ", frequencyPenalty=" + this.frequencyPenalty + ", presencePenalty=" + this.presencePenalty + ", logitBias=" + this.logitBias + ", user=" + this.user + ")";
        }
    }

    public static enum Model {
        GPT_3_5_TURBO("gpt-3.5-turbo"),
        GPT_3_5_TURBO_1106("gpt-3.5-turbo-1106"),
        GPT_3_5_TURBO_16K("gpt-3.5-turbo-16k"),
        GPT_4("gpt-4"),
        GPT_4o("gpt-4o"),
        GPT_4_1106_PREVIEW("gpt-4-1106-preview"),
        GPT_4_32K("gpt-4-32k"),
        CHATGLM_LITE("chatglm_lite"),
        CHATGLM_STD("chatglm_std"),
        CHATGLM_PRO("chatglm_pro"),
        CHATGLM_TURBO("chatglm_turbo");

        private String code;

        public String getCode() {
            return this.code;
        }

        private Model(String code) {
            this.code = code;
        }
    }
}

