/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.chatgpt.domain.edits;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditRequest
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(EditRequest.class);
    @NonNull
    private String model = Model.CODE_DAVINCI_EDIT_001.getCode();
    @NonNull
    private String input;
    @NonNull
    private String instruction;
    private double temperature;
    @JsonProperty(value="top_p")
    private Double topP = 1.0;
    private Integer n = 1;

    private static double $default$temperature() {
        return 0.2;
    }

    public static EditRequestBuilder builder() {
        return new EditRequestBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public String getInput() {
        return this.input;
    }

    @NonNull
    public String getInstruction() {
        return this.instruction;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public EditRequest() {
        this.temperature = EditRequest.$default$temperature();
    }

    public EditRequest(@NonNull String model, @NonNull String input, @NonNull String instruction, double temperature, Double topP, Integer n) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (instruction == null) {
            throw new NullPointerException("instruction is marked non-null but is null");
        }
        this.model = model;
        this.input = input;
        this.instruction = instruction;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
    }

    public static class EditRequestBuilder {
        private String model;
        private String input;
        private String instruction;
        private boolean temperature$set;
        private double temperature$value;
        private Double topP;
        private Integer n;

        EditRequestBuilder() {
        }

        public EditRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public EditRequestBuilder input(@NonNull String input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public EditRequestBuilder instruction(@NonNull String instruction) {
            if (instruction == null) {
                throw new NullPointerException("instruction is marked non-null but is null");
            }
            this.instruction = instruction;
            return this;
        }

        public EditRequestBuilder temperature(double temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        @JsonProperty(value="top_p")
        public EditRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public EditRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public EditRequest build() {
            double temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = EditRequest.$default$temperature();
            }
            return new EditRequest(this.model, this.input, this.instruction, temperature$value, this.topP, this.n);
        }

        public String toString() {
            return "EditRequest.EditRequestBuilder(model=" + this.model + ", input=" + this.input + ", instruction=" + this.instruction + ", temperature$value=" + this.temperature$value + ", topP=" + this.topP + ", n=" + this.n + ")";
        }
    }

    public static enum Model {
        TEXT_DAVINCI_EDIT_001("text-davinci-edit-001"),
        CODE_DAVINCI_EDIT_001("code-davinci-edit-001");

        private String code;

        public String getCode() {
            return this.code;
        }

        private Model(String code) {
            this.code = code;
        }
    }
}

