/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.chatgpt.domain.embedd;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EmbeddingRequest
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(EmbeddingRequest.class);
    @NonNull
    private String model;
    @NonNull
    private List<String> input;
    private String user;

    private static String $default$model() {
        return Model.TEXT_EMBEDDING_ADA_002.getCode();
    }

    public static EmbeddingRequestBuilder builder() {
        return new EmbeddingRequestBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public List<String> getInput() {
        return this.input;
    }

    public String getUser() {
        return this.user;
    }

    public EmbeddingRequest() {
        this.model = EmbeddingRequest.$default$model();
    }

    public EmbeddingRequest(@NonNull String model, @NonNull List<String> input, String user) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.model = model;
        this.input = input;
        this.user = user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public static class EmbeddingRequestBuilder {
        private boolean model$set;
        private String model$value;
        private List<String> input;
        private String user;

        EmbeddingRequestBuilder() {
        }

        public EmbeddingRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public EmbeddingRequestBuilder input(@NonNull List<String> input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public EmbeddingRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public EmbeddingRequest build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = EmbeddingRequest.$default$model();
            }
            return new EmbeddingRequest(model$value, this.input, this.user);
        }

        public String toString() {
            return "EmbeddingRequest.EmbeddingRequestBuilder(model$value=" + this.model$value + ", input=" + this.input + ", user=" + this.user + ")";
        }
    }

    public static enum Model {
        TEXT_EMBEDDING_ADA_002("text-embedding-ada-002");

        private String code;

        public String getCode() {
            return this.code;
        }

        private Model(String code) {
            this.code = code;
        }
    }
}

