/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.chatgpt.domain.qa;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class QACompletionRequest
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(QACompletionRequest.class);
    @NonNull
    private String model;
    @NonNull
    private String prompt;
    private String suffix;
    private double temperature = 0.2;
    @JsonProperty(value="top_p")
    private Double topP = 1.0;
    private Integer n = 1;
    private boolean stream = false;
    private List<String> stop;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens = 2048;
    private boolean echo;
    @JsonProperty(value="frequency_penalty")
    private double frequencyPenalty = 0.0;
    @JsonProperty(value="presence_penalty")
    private double presencePenalty = 0.0;
    @JsonProperty(value="best_of")
    private Integer bestOf;
    private Integer logprobs;
    @JsonProperty(value="logit_bias")
    private Map logitBias;
    private String user;

    private static String $default$model() {
        return Model.TEXT_DAVINCI_003.getCode();
    }

    private static boolean $default$echo() {
        return false;
    }

    private static Integer $default$bestOf() {
        return 1;
    }

    public static QACompletionRequestBuilder builder() {
        return new QACompletionRequestBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public String getPrompt() {
        return this.prompt;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public boolean isStream() {
        return this.stream;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Integer getBestOf() {
        return this.bestOf;
    }

    public Integer getLogprobs() {
        return this.logprobs;
    }

    public Map getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setPrompt(@NonNull String prompt) {
        if (prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.prompt = prompt;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="best_of")
    public void setBestOf(Integer bestOf) {
        this.bestOf = bestOf;
    }

    public void setLogprobs(Integer logprobs) {
        this.logprobs = logprobs;
    }

    @JsonProperty(value="logit_bias")
    public void setLogitBias(Map logitBias) {
        this.logitBias = logitBias;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QACompletionRequest)) {
            return false;
        }
        QACompletionRequest other = (QACompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (this.isEcho() != other.isEcho()) {
            return false;
        }
        if (Double.compare(this.getFrequencyPenalty(), other.getFrequencyPenalty()) != 0) {
            return false;
        }
        if (Double.compare(this.getPresencePenalty(), other.getPresencePenalty()) != 0) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Integer this$bestOf = this.getBestOf();
        Integer other$bestOf = other.getBestOf();
        if (this$bestOf == null ? other$bestOf != null : !((Object)this$bestOf).equals(other$bestOf)) {
            return false;
        }
        Integer this$logprobs = this.getLogprobs();
        Integer other$logprobs = other.getLogprobs();
        if (this$logprobs == null ? other$logprobs != null : !((Object)this$logprobs).equals(other$logprobs)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map this$logitBias = this.getLogitBias();
        Map other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QACompletionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        result = result * 59 + (this.isStream() ? 79 : 97);
        result = result * 59 + (this.isEcho() ? 79 : 97);
        long $frequencyPenalty = Double.doubleToLongBits(this.getFrequencyPenalty());
        result = result * 59 + (int)($frequencyPenalty >>> 32 ^ $frequencyPenalty);
        long $presencePenalty = Double.doubleToLongBits(this.getPresencePenalty());
        result = result * 59 + (int)($presencePenalty >>> 32 ^ $presencePenalty);
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Integer $bestOf = this.getBestOf();
        result = result * 59 + ($bestOf == null ? 43 : ((Object)$bestOf).hashCode());
        Integer $logprobs = this.getLogprobs();
        result = result * 59 + ($logprobs == null ? 43 : ((Object)$logprobs).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "QACompletionRequest(model=" + this.getModel() + ", prompt=" + this.getPrompt() + ", suffix=" + this.getSuffix() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", n=" + this.getN() + ", stream=" + this.isStream() + ", stop=" + this.getStop() + ", maxTokens=" + this.getMaxTokens() + ", echo=" + this.isEcho() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", presencePenalty=" + this.getPresencePenalty() + ", bestOf=" + this.getBestOf() + ", logprobs=" + this.getLogprobs() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ")";
    }

    public QACompletionRequest() {
        this.model = QACompletionRequest.$default$model();
        this.echo = QACompletionRequest.$default$echo();
        this.bestOf = QACompletionRequest.$default$bestOf();
    }

    public QACompletionRequest(@NonNull String model, @NonNull String prompt, String suffix, double temperature, Double topP, Integer n, boolean stream, List<String> stop, Integer maxTokens, boolean echo, double frequencyPenalty, double presencePenalty, Integer bestOf, Integer logprobs, Map logitBias, String user) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.model = model;
        this.prompt = prompt;
        this.suffix = suffix;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.echo = echo;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.bestOf = bestOf;
        this.logprobs = logprobs;
        this.logitBias = logitBias;
        this.user = user;
    }

    public static class QACompletionRequestBuilder {
        private boolean model$set;
        private String model$value;
        private String prompt;
        private String suffix;
        private double temperature;
        private Double topP;
        private Integer n;
        private boolean stream;
        private List<String> stop;
        private Integer maxTokens;
        private boolean echo$set;
        private boolean echo$value;
        private double frequencyPenalty;
        private double presencePenalty;
        private boolean bestOf$set;
        private Integer bestOf$value;
        private Integer logprobs;
        private Map logitBias;
        private String user;

        QACompletionRequestBuilder() {
        }

        public QACompletionRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public QACompletionRequestBuilder prompt(@NonNull String prompt) {
            if (prompt == null) {
                throw new NullPointerException("prompt is marked non-null but is null");
            }
            this.prompt = prompt;
            return this;
        }

        public QACompletionRequestBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public QACompletionRequestBuilder temperature(double temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="top_p")
        public QACompletionRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QACompletionRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public QACompletionRequestBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public QACompletionRequestBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public QACompletionRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public QACompletionRequestBuilder echo(boolean echo) {
            this.echo$value = echo;
            this.echo$set = true;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public QACompletionRequestBuilder frequencyPenalty(double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public QACompletionRequestBuilder presencePenalty(double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @JsonProperty(value="best_of")
        public QACompletionRequestBuilder bestOf(Integer bestOf) {
            this.bestOf$value = bestOf;
            this.bestOf$set = true;
            return this;
        }

        public QACompletionRequestBuilder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public QACompletionRequestBuilder logitBias(Map logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public QACompletionRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public QACompletionRequest build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = QACompletionRequest.$default$model();
            }
            boolean echo$value = this.echo$value;
            if (!this.echo$set) {
                echo$value = QACompletionRequest.$default$echo();
            }
            Integer bestOf$value = this.bestOf$value;
            if (!this.bestOf$set) {
                bestOf$value = QACompletionRequest.$default$bestOf();
            }
            return new QACompletionRequest(model$value, this.prompt, this.suffix, this.temperature, this.topP, this.n, this.stream, this.stop, this.maxTokens, echo$value, this.frequencyPenalty, this.presencePenalty, bestOf$value, this.logprobs, this.logitBias, this.user);
        }

        public String toString() {
            return "QACompletionRequest.QACompletionRequestBuilder(model$value=" + this.model$value + ", prompt=" + this.prompt + ", suffix=" + this.suffix + ", temperature=" + this.temperature + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", stop=" + this.stop + ", maxTokens=" + this.maxTokens + ", echo$value=" + this.echo$value + ", frequencyPenalty=" + this.frequencyPenalty + ", presencePenalty=" + this.presencePenalty + ", bestOf$value=" + this.bestOf$value + ", logprobs=" + this.logprobs + ", logitBias=" + this.logitBias + ", user=" + this.user + ")";
        }
    }

    public static enum Model {
        TEXT_DAVINCI_003("text-davinci-003"),
        TEXT_DAVINCI_002("text-davinci-002"),
        DAVINCI("davinci");

        private String code;

        public String getCode() {
            return this.code;
        }

        private Model(String code) {
            this.code = code;
        }
    }
}

