/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.chatgpt.domain.whisper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import plus.gaga.middleware.chatgpt.domain.whisper.WhisperEnum;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TranscriptionsRequest {
    private String model;
    private String prompt;
    @JsonProperty(value="response_format")
    private String responseFormat;
    private double temperature = 0.2;
    private String language;

    private static String $default$model() {
        return WhisperEnum.Model.WHISPER_1.getCode();
    }

    private static String $default$responseFormat() {
        return WhisperEnum.ResponseFormat.JSON.getCode();
    }

    public static TranscriptionsRequestBuilder builder() {
        return new TranscriptionsRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @JsonProperty(value="response_format")
    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranscriptionsRequest)) {
            return false;
        }
        TranscriptionsRequest other = (TranscriptionsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        String this$responseFormat = this.getResponseFormat();
        String other$responseFormat = other.getResponseFormat();
        if (this$responseFormat == null ? other$responseFormat != null : !this$responseFormat.equals(other$responseFormat)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !this$language.equals(other$language));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TranscriptionsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        String $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : $responseFormat.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }

    public String toString() {
        return "TranscriptionsRequest(model=" + this.getModel() + ", prompt=" + this.getPrompt() + ", responseFormat=" + this.getResponseFormat() + ", temperature=" + this.getTemperature() + ", language=" + this.getLanguage() + ")";
    }

    public TranscriptionsRequest() {
        this.model = TranscriptionsRequest.$default$model();
        this.responseFormat = TranscriptionsRequest.$default$responseFormat();
    }

    public TranscriptionsRequest(String model, String prompt, String responseFormat, double temperature, String language) {
        this.model = model;
        this.prompt = prompt;
        this.responseFormat = responseFormat;
        this.temperature = temperature;
        this.language = language;
    }

    public static final class Fields {
        public static final String model = "model";
        public static final String prompt = "prompt";
        public static final String responseFormat = "responseFormat";
        public static final String temperature = "temperature";
        public static final String language = "language";

        private Fields() {
        }
    }

    public static class TranscriptionsRequestBuilder {
        private boolean model$set;
        private String model$value;
        private String prompt;
        private boolean responseFormat$set;
        private String responseFormat$value;
        private double temperature;
        private String language;

        TranscriptionsRequestBuilder() {
        }

        public TranscriptionsRequestBuilder model(String model) {
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public TranscriptionsRequestBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        @JsonProperty(value="response_format")
        public TranscriptionsRequestBuilder responseFormat(String responseFormat) {
            this.responseFormat$value = responseFormat;
            this.responseFormat$set = true;
            return this;
        }

        public TranscriptionsRequestBuilder temperature(double temperature) {
            this.temperature = temperature;
            return this;
        }

        public TranscriptionsRequestBuilder language(String language) {
            this.language = language;
            return this;
        }

        public TranscriptionsRequest build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = TranscriptionsRequest.$default$model();
            }
            String responseFormat$value = this.responseFormat$value;
            if (!this.responseFormat$set) {
                responseFormat$value = TranscriptionsRequest.$default$responseFormat();
            }
            return new TranscriptionsRequest(model$value, this.prompt, responseFormat$value, this.temperature, this.language);
        }

        public String toString() {
            return "TranscriptionsRequest.TranscriptionsRequestBuilder(model$value=" + this.model$value + ", prompt=" + this.prompt + ", responseFormat$value=" + this.responseFormat$value + ", temperature=" + this.temperature + ", language=" + this.language + ")";
        }
    }
}

