/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.chatgpt.interceptor;

import cn.hutool.http.ContentType;
import cn.hutool.http.Header;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class OpenAiInterceptor
implements Interceptor {
    private final String apiKeyBySystem;

    public OpenAiInterceptor(String apiKeyBySystem) {
        this.apiKeyBySystem = apiKeyBySystem;
    }

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        String apiKeyByUser = original.header("apiKey");
        String apiKey = null == apiKeyByUser ? this.apiKeyBySystem : apiKeyByUser;
        Request request = original.newBuilder().url(original.url()).header(Header.AUTHORIZATION.getValue(), "Bearer " + apiKey).header(Header.CONTENT_TYPE.getValue(), ContentType.JSON.getValue()).method(original.method(), original.body()).build();
        return chain.proceed(request);
    }
}

