/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.chatgpt.session;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import plus.gaga.middleware.chatgpt.domain.billing.BillingUsage;
import plus.gaga.middleware.chatgpt.domain.billing.Subscription;
import plus.gaga.middleware.chatgpt.domain.chat.ChatCompletionRequest;
import plus.gaga.middleware.chatgpt.domain.chat.ChatCompletionResponse;
import plus.gaga.middleware.chatgpt.domain.edits.EditRequest;
import plus.gaga.middleware.chatgpt.domain.edits.EditResponse;
import plus.gaga.middleware.chatgpt.domain.embedd.EmbeddingRequest;
import plus.gaga.middleware.chatgpt.domain.embedd.EmbeddingResponse;
import plus.gaga.middleware.chatgpt.domain.files.DeleteFileResponse;
import plus.gaga.middleware.chatgpt.domain.files.UploadFileResponse;
import plus.gaga.middleware.chatgpt.domain.images.ImageEditRequest;
import plus.gaga.middleware.chatgpt.domain.images.ImageRequest;
import plus.gaga.middleware.chatgpt.domain.images.ImageResponse;
import plus.gaga.middleware.chatgpt.domain.other.OpenAiResponse;
import plus.gaga.middleware.chatgpt.domain.qa.QACompletionRequest;
import plus.gaga.middleware.chatgpt.domain.qa.QACompletionResponse;
import plus.gaga.middleware.chatgpt.domain.vision.VisionCompletionRequest;
import plus.gaga.middleware.chatgpt.domain.vision.VisionCompletionResponse;
import plus.gaga.middleware.chatgpt.domain.whisper.TranscriptionsRequest;
import plus.gaga.middleware.chatgpt.domain.whisper.TranslationsRequest;
import plus.gaga.middleware.chatgpt.domain.whisper.WhisperResponse;

public interface OpenAiSession {
    public QACompletionResponse completions(String var1);

    public QACompletionResponse completions(QACompletionRequest var1);

    public EventSource completions(QACompletionRequest var1, EventSourceListener var2) throws JsonProcessingException;

    public ChatCompletionResponse completions(ChatCompletionRequest var1);

    public VisionCompletionResponse completions(VisionCompletionRequest var1);

    public VisionCompletionResponse completions(String var1, String var2, VisionCompletionRequest var3) throws IOException;

    public EventSource completions(VisionCompletionRequest var1, EventSourceListener var2) throws IOException;

    public EventSource completions(String var1, String var2, VisionCompletionRequest var3, EventSourceListener var4) throws IOException;

    public EventSource chatCompletions(ChatCompletionRequest var1, EventSourceListener var2) throws JsonProcessingException;

    public EventSource chatCompletions(String var1, ChatCompletionRequest var2, EventSourceListener var3) throws JsonProcessingException;

    public EventSource chatCompletions(String var1, String var2, ChatCompletionRequest var3, EventSourceListener var4) throws JsonProcessingException;

    public EditResponse edit(EditRequest var1);

    public ImageResponse genImages(String var1);

    public ImageResponse genImages(ImageRequest var1);

    public ImageResponse genImages(String var1, String var2, ImageRequest var3) throws IOException;

    public ImageResponse editImages(File var1, String var2);

    public ImageResponse editImages(File var1, ImageEditRequest var2);

    public ImageResponse editImages(File var1, File var2, ImageEditRequest var3);

    public EmbeddingResponse embeddings(String var1);

    public EmbeddingResponse embeddings(String ... var1);

    public EmbeddingResponse embeddings(List<String> var1);

    public EmbeddingResponse embeddings(EmbeddingRequest var1);

    public OpenAiResponse<File> files();

    public UploadFileResponse uploadFile(File var1);

    public UploadFileResponse uploadFile(String var1, File var2);

    public DeleteFileResponse deleteFile(String var1);

    public WhisperResponse speed2TextTranscriptions(File var1, TranscriptionsRequest var2);

    public WhisperResponse speed2TextTranslations(File var1, TranslationsRequest var2);

    public Subscription subscription();

    public BillingUsage billingUsage(@NotNull LocalDate var1, @NotNull LocalDate var2);
}

