/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.chatgpt.session.defaults;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.Single;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import plus.gaga.middleware.chatgpt.IOpenAiApi;
import plus.gaga.middleware.chatgpt.domain.billing.BillingUsage;
import plus.gaga.middleware.chatgpt.domain.billing.Subscription;
import plus.gaga.middleware.chatgpt.domain.chat.ChatCompletionRequest;
import plus.gaga.middleware.chatgpt.domain.chat.ChatCompletionResponse;
import plus.gaga.middleware.chatgpt.domain.edits.EditRequest;
import plus.gaga.middleware.chatgpt.domain.edits.EditResponse;
import plus.gaga.middleware.chatgpt.domain.embedd.EmbeddingRequest;
import plus.gaga.middleware.chatgpt.domain.embedd.EmbeddingResponse;
import plus.gaga.middleware.chatgpt.domain.files.DeleteFileResponse;
import plus.gaga.middleware.chatgpt.domain.files.UploadFileResponse;
import plus.gaga.middleware.chatgpt.domain.images.ImageEditRequest;
import plus.gaga.middleware.chatgpt.domain.images.ImageRequest;
import plus.gaga.middleware.chatgpt.domain.images.ImageResponse;
import plus.gaga.middleware.chatgpt.domain.other.OpenAiResponse;
import plus.gaga.middleware.chatgpt.domain.qa.QACompletionRequest;
import plus.gaga.middleware.chatgpt.domain.qa.QACompletionResponse;
import plus.gaga.middleware.chatgpt.domain.vision.VisionCompletionRequest;
import plus.gaga.middleware.chatgpt.domain.vision.VisionCompletionResponse;
import plus.gaga.middleware.chatgpt.domain.whisper.TranscriptionsRequest;
import plus.gaga.middleware.chatgpt.domain.whisper.TranslationsRequest;
import plus.gaga.middleware.chatgpt.domain.whisper.WhisperResponse;
import plus.gaga.middleware.chatgpt.session.Configuration;
import plus.gaga.middleware.chatgpt.session.OpenAiSession;

public class DefaultOpenAiSession
implements OpenAiSession {
    private final Configuration configuration;
    private final IOpenAiApi openAiApi;
    private final EventSource.Factory factory;
    private final OkHttpClient okHttpClient;

    public DefaultOpenAiSession(Configuration configuration) {
        this.configuration = configuration;
        this.openAiApi = configuration.getOpenAiApi();
        this.factory = configuration.createRequestFactory();
        this.okHttpClient = configuration.getOkHttpClient();
    }

    @Override
    public QACompletionResponse completions(QACompletionRequest qaCompletionRequest) {
        return (QACompletionResponse)this.openAiApi.completions(qaCompletionRequest).blockingGet();
    }

    @Override
    public EventSource completions(QACompletionRequest qaCompletionRequest, EventSourceListener eventSourceListener) throws JsonProcessingException {
        if (!qaCompletionRequest.isStream()) {
            throw new RuntimeException("illegal parameter stream is false!");
        }
        Request request = new Request.Builder().url(this.configuration.getApiHost().concat("v1/completions")).post(RequestBody.create((MediaType)MediaType.parse((String)ContentType.JSON.getValue()), (String)new ObjectMapper().writeValueAsString((Object)qaCompletionRequest))).build();
        return this.factory.newEventSource(request, eventSourceListener);
    }

    @Override
    public QACompletionResponse completions(String question) {
        QACompletionRequest request = QACompletionRequest.builder().prompt(question).build();
        Single<QACompletionResponse> completions = this.openAiApi.completions(request);
        return (QACompletionResponse)completions.blockingGet();
    }

    @Override
    public ChatCompletionResponse completions(ChatCompletionRequest chatCompletionRequest) {
        return (ChatCompletionResponse)this.openAiApi.completions(chatCompletionRequest).blockingGet();
    }

    @Override
    public VisionCompletionResponse completions(VisionCompletionRequest visionCompletionRequest) {
        Single<VisionCompletionResponse> completions = this.openAiApi.completions(visionCompletionRequest);
        return (VisionCompletionResponse)this.openAiApi.completions(visionCompletionRequest).blockingGet();
    }

    @Override
    public VisionCompletionResponse completions(String apiHostByUser, String apiKeyByUser, VisionCompletionRequest visionCompletionRequest) throws IOException {
        String apiHost = "NULL".equals(apiHostByUser) ? this.configuration.getApiHost() : apiHostByUser;
        String apiKey = "NULL".equals(apiKeyByUser) ? this.configuration.getApiKey() : apiKeyByUser;
        Request request = new Request.Builder().url(apiHost.concat("v1/chat/completions")).addHeader("apiKey", apiKey).post(RequestBody.create((MediaType)MediaType.parse((String)ContentType.JSON.getValue()), (String)new ObjectMapper().writeValueAsString((Object)visionCompletionRequest))).build();
        OkHttpClient okHttpClient = this.configuration.getOkHttpClient();
        Response response = okHttpClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new RuntimeException("Request failed");
        }
        return (VisionCompletionResponse)JSON.parseObject((String)response.body().string(), VisionCompletionResponse.class);
    }

    @Override
    public EventSource completions(VisionCompletionRequest visionCompletionRequest, EventSourceListener eventSourceListener) throws IOException {
        return this.completions("NULL", "NULL", visionCompletionRequest, eventSourceListener);
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, VisionCompletionRequest visionCompletionRequest, EventSourceListener eventSourceListener) throws IOException {
        String apiHost = "NULL".equals(apiHostByUser) ? this.configuration.getApiHost() : apiHostByUser;
        String apiKey = "NULL".equals(apiKeyByUser) ? this.configuration.getApiKey() : apiKeyByUser;
        Request request = new Request.Builder().url(apiHost.concat("v1/chat/completions")).addHeader("apiKey", apiKey).post(RequestBody.create((MediaType)MediaType.parse((String)ContentType.JSON.getValue()), (String)new ObjectMapper().writeValueAsString((Object)visionCompletionRequest))).build();
        return this.factory.newEventSource(request, eventSourceListener);
    }

    @Override
    public EventSource chatCompletions(ChatCompletionRequest chatCompletionRequest, EventSourceListener eventSourceListener) throws JsonProcessingException {
        return this.chatCompletions("NULL", "NULL", chatCompletionRequest, eventSourceListener);
    }

    @Override
    public EventSource chatCompletions(String apiKey, ChatCompletionRequest chatCompletionRequest, EventSourceListener eventSourceListener) throws JsonProcessingException {
        return this.chatCompletions("NULL", apiKey, chatCompletionRequest, eventSourceListener);
    }

    @Override
    public EventSource chatCompletions(String apiHostByUser, String apiKeyByUser, ChatCompletionRequest chatCompletionRequest, EventSourceListener eventSourceListener) throws JsonProcessingException {
        if (!chatCompletionRequest.isStream()) {
            throw new RuntimeException("illegal parameter stream is false!");
        }
        String apiHost = "NULL".equals(apiHostByUser) ? this.configuration.getApiHost() : apiHostByUser;
        String apiKey = "NULL".equals(apiKeyByUser) ? this.configuration.getApiKey() : apiKeyByUser;
        Request request = new Request.Builder().url(apiHost.concat("v1/chat/completions")).addHeader("apiKey", apiKey).post(RequestBody.create((MediaType)MediaType.parse((String)ContentType.JSON.getValue()), (String)new ObjectMapper().writeValueAsString((Object)chatCompletionRequest))).build();
        return this.factory.newEventSource(request, eventSourceListener);
    }

    @Override
    public EditResponse edit(EditRequest editRequest) {
        return (EditResponse)this.openAiApi.edits(editRequest).blockingGet();
    }

    @Override
    public ImageResponse genImages(String prompt) {
        ImageRequest imageRequest = ImageRequest.builder().prompt(prompt).build();
        return this.genImages(imageRequest);
    }

    @Override
    public ImageResponse genImages(ImageRequest imageRequest) {
        return (ImageResponse)this.openAiApi.genImages(imageRequest).blockingGet();
    }

    @Override
    public ImageResponse genImages(String apiHostByUser, String apiKeyByUser, ImageRequest imageRequest) throws IOException {
        String apiHost = "NULL".equals(apiHostByUser) ? this.configuration.getApiHost() : apiHostByUser;
        String apiKey = "NULL".equals(apiKeyByUser) ? this.configuration.getApiKey() : apiKeyByUser;
        Request request = new Request.Builder().url(apiHost.concat("v1/images/generations")).addHeader("apiKey", apiKey).post(RequestBody.create((MediaType)MediaType.parse((String)ContentType.JSON.getValue()), (String)new ObjectMapper().writeValueAsString((Object)imageRequest))).build();
        Call call = this.okHttpClient.newCall(request);
        Response execute = call.execute();
        ResponseBody body = execute.body();
        if (execute.isSuccessful() && body != null) {
            String responseBody = body.string();
            ObjectMapper objectMapper = new ObjectMapper();
            return (ImageResponse)objectMapper.readValue(responseBody, ImageResponse.class);
        }
        throw new IOException("Failed to get image response");
    }

    @Override
    public ImageResponse editImages(File image, String prompt) {
        ImageEditRequest imageEditRequest = ImageEditRequest.builder().prompt(prompt).build();
        return this.editImages(image, null, imageEditRequest);
    }

    @Override
    public ImageResponse editImages(File image, ImageEditRequest imageEditRequest) {
        return this.editImages(image, null, imageEditRequest);
    }

    @Override
    public ImageResponse editImages(File image, File mask, ImageEditRequest imageEditRequest) {
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)image);
        MultipartBody.Part imageMultipartBody = MultipartBody.Part.createFormData((String)"image", (String)image.getName(), (RequestBody)imageBody);
        MultipartBody.Part maskMultipartBody = null;
        if (Objects.nonNull(mask)) {
            RequestBody maskBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)mask);
            maskMultipartBody = MultipartBody.Part.createFormData((String)"mask", (String)mask.getName(), (RequestBody)maskBody);
        }
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>();
        requestBodyMap.put("prompt", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEditRequest.getPrompt()));
        requestBodyMap.put("n", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEditRequest.getN().toString()));
        requestBodyMap.put("size", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEditRequest.getSize()));
        requestBodyMap.put("response_format", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEditRequest.getResponseFormat()));
        if (!Objects.isNull(imageEditRequest.getUser()) && !"".equals(imageEditRequest.getUser())) {
            requestBodyMap.put("user", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEditRequest.getUser()));
        }
        return (ImageResponse)this.openAiApi.editImages(imageMultipartBody, maskMultipartBody, requestBodyMap).blockingGet();
    }

    @Override
    public EmbeddingResponse embeddings(final String input) {
        EmbeddingRequest embeddingRequest = EmbeddingRequest.builder().input((List<String>)new ArrayList<String>(){
            {
                this.add(input);
            }
        }).build();
        return this.embeddings(embeddingRequest);
    }

    @Override
    public EmbeddingResponse embeddings(String ... inputs) {
        EmbeddingRequest embeddingRequest = EmbeddingRequest.builder().input(Arrays.asList(inputs)).build();
        return this.embeddings(embeddingRequest);
    }

    @Override
    public EmbeddingResponse embeddings(List<String> inputs) {
        EmbeddingRequest embeddingRequest = EmbeddingRequest.builder().input(inputs).build();
        return this.embeddings(embeddingRequest);
    }

    @Override
    public EmbeddingResponse embeddings(EmbeddingRequest embeddingRequest) {
        return (EmbeddingResponse)this.openAiApi.embeddings(embeddingRequest).blockingGet();
    }

    @Override
    public OpenAiResponse<File> files() {
        return (OpenAiResponse)this.openAiApi.files().blockingGet();
    }

    @Override
    public UploadFileResponse uploadFile(File file) {
        return this.uploadFile("fine-tune", file);
    }

    @Override
    public UploadFileResponse uploadFile(String purpose, File file) {
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        RequestBody purposeBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)purpose);
        return (UploadFileResponse)this.openAiApi.uploadFile(multipartBody, purposeBody).blockingGet();
    }

    @Override
    public DeleteFileResponse deleteFile(String fileId) {
        return (DeleteFileResponse)this.openAiApi.deleteFile(fileId).blockingGet();
    }

    @Override
    public WhisperResponse speed2TextTranscriptions(File file, TranscriptionsRequest transcriptionsRequest) {
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>();
        if (StrUtil.isNotBlank((CharSequence)transcriptionsRequest.getLanguage())) {
            requestBodyMap.put("language", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)transcriptionsRequest.getLanguage()));
        }
        if (StrUtil.isNotBlank((CharSequence)transcriptionsRequest.getModel())) {
            requestBodyMap.put("model", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)transcriptionsRequest.getModel()));
        }
        if (StrUtil.isNotBlank((CharSequence)transcriptionsRequest.getPrompt())) {
            requestBodyMap.put("prompt", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)transcriptionsRequest.getPrompt()));
        }
        if (StrUtil.isNotBlank((CharSequence)transcriptionsRequest.getResponseFormat())) {
            requestBodyMap.put("responseFormat", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)transcriptionsRequest.getResponseFormat()));
        }
        requestBodyMap.put("temperature", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)String.valueOf(transcriptionsRequest.getTemperature())));
        return (WhisperResponse)this.openAiApi.speed2TextTranscriptions(multipartBody, requestBodyMap).blockingGet();
    }

    @Override
    public WhisperResponse speed2TextTranslations(File file, TranslationsRequest translationsRequest) {
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>();
        if (StrUtil.isNotBlank((CharSequence)translationsRequest.getModel())) {
            requestBodyMap.put("model", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)translationsRequest.getModel()));
        }
        if (StrUtil.isNotBlank((CharSequence)translationsRequest.getPrompt())) {
            requestBodyMap.put("prompt", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)translationsRequest.getPrompt()));
        }
        if (StrUtil.isNotBlank((CharSequence)translationsRequest.getResponseFormat())) {
            requestBodyMap.put("responseFormat", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)translationsRequest.getResponseFormat()));
        }
        requestBodyMap.put("temperature", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)String.valueOf(translationsRequest.getTemperature())));
        requestBodyMap.put("temperature", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)String.valueOf(translationsRequest.getTemperature())));
        return (WhisperResponse)this.openAiApi.speed2TextTranscriptions(multipartBody, requestBodyMap).blockingGet();
    }

    @Override
    public Subscription subscription() {
        return (Subscription)this.openAiApi.subscription().blockingGet();
    }

    @Override
    public BillingUsage billingUsage(@NotNull LocalDate starDate, @NotNull LocalDate endDate) {
        return (BillingUsage)this.openAiApi.billingUsage(starDate, endDate).blockingGet();
    }
}

