/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.chatgpt.session.defaults;

import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import plus.gaga.middleware.chatgpt.IOpenAiApi;
import plus.gaga.middleware.chatgpt.interceptor.OpenAiInterceptor;
import plus.gaga.middleware.chatgpt.session.Configuration;
import plus.gaga.middleware.chatgpt.session.OpenAiSession;
import plus.gaga.middleware.chatgpt.session.OpenAiSessionFactory;
import plus.gaga.middleware.chatgpt.session.defaults.DefaultOpenAiSession;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class DefaultOpenAiSessionFactory
implements OpenAiSessionFactory {
    private final Configuration configuration;

    public DefaultOpenAiSessionFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public OpenAiSession openSession() {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(this.configuration.getLevel());
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)httpLoggingInterceptor).addInterceptor((Interceptor)new OpenAiInterceptor(this.configuration.getApiKey())).connectTimeout(450L, TimeUnit.SECONDS).writeTimeout(450L, TimeUnit.SECONDS).readTimeout(450L, TimeUnit.SECONDS).build();
        this.configuration.setOkHttpClient(okHttpClient);
        IOpenAiApi openAiApi = (IOpenAiApi)new Retrofit.Builder().baseUrl(this.configuration.getApiHost()).client(okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(IOpenAiApi.class);
        this.configuration.setOpenAiApi(openAiApi);
        return new DefaultOpenAiSession(this.configuration);
    }
}

