/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.db.router.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import plus.gaga.middleware.db.router.DBRouterConfig;
import plus.gaga.middleware.db.router.DBRouterJoinPoint;
import plus.gaga.middleware.db.router.dynamic.DynamicDataSource;
import plus.gaga.middleware.db.router.dynamic.DynamicMybatisPlugin;
import plus.gaga.middleware.db.router.strategy.IDBRouterStrategy;
import plus.gaga.middleware.db.router.strategy.impl.DBRouterStrategyHashCode;
import plus.gaga.middleware.db.router.util.PropertyUtil;
import plus.gaga.middleware.db.router.util.StringUtils;

@Configuration
public class DataSourceAutoConfig
implements EnvironmentAware {
    private static final String TAG_GLOBAL = "global";
    private static final String TAG_POOL = "pool";
    private Map<String, Map<String, Object>> dataSourceMap = new HashMap<String, Map<String, Object>>();
    private Map<String, Object> defaultDataSourceConfig;
    private int dbCount;
    private int tbCount;
    private String routerKey;

    @Bean(name={"db-router-point"})
    @ConditionalOnMissingBean
    public DBRouterJoinPoint point(DBRouterConfig dbRouterConfig, IDBRouterStrategy dbRouterStrategy) {
        return new DBRouterJoinPoint(dbRouterConfig, dbRouterStrategy);
    }

    @Bean
    public DBRouterConfig dbRouterConfig() {
        return new DBRouterConfig(this.dbCount, this.tbCount, this.routerKey);
    }

    @Bean
    public Interceptor plugin() {
        return new DynamicMybatisPlugin();
    }

    private DataSource createDataSource(Map<String, Object> attributes) {
        try {
            DataSourceProperties dataSourceProperties = new DataSourceProperties();
            dataSourceProperties.setUrl(attributes.get("url").toString());
            dataSourceProperties.setUsername(attributes.get("username").toString());
            dataSourceProperties.setPassword(attributes.get("password").toString());
            String driverClassName = attributes.get("driver-class-name") == null ? "com.zaxxer.hikari.HikariDataSource" : attributes.get("driver-class-name").toString();
            dataSourceProperties.setDriverClassName(driverClassName);
            String typeClassName = attributes.get("type-class-name") == null ? "com.zaxxer.hikari.HikariDataSource" : attributes.get("type-class-name").toString();
            DataSource ds = dataSourceProperties.initializeDataSourceBuilder().type(Class.forName(typeClassName)).build();
            MetaObject dsMeta = SystemMetaObject.forObject((Object)ds);
            Map poolProps = attributes.containsKey(TAG_POOL) ? attributes.get(TAG_POOL) : Collections.EMPTY_MAP;
            for (Map.Entry entry : poolProps.entrySet()) {
                String key = StringUtils.middleScoreToCamelCase((String)entry.getKey());
                if (!dsMeta.hasSetter(key)) continue;
                dsMeta.setValue(key, entry.getValue());
            }
            return ds;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("can not find datasource type class by class name", e);
        }
    }

    @Bean(value={"mysqlDataSource"})
    public DataSource createDataSource() {
        HashMap<String, DataSource> targetDataSources = new HashMap<String, DataSource>();
        for (String dbInfo : this.dataSourceMap.keySet()) {
            Map<String, Object> objMap = this.dataSourceMap.get(dbInfo);
            DataSource ds = this.createDataSource(objMap);
            targetDataSources.put(dbInfo, ds);
        }
        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        dynamicDataSource.setTargetDataSources(targetDataSources);
        dynamicDataSource.setDefaultTargetDataSource(this.createDataSource(this.defaultDataSourceConfig));
        return dynamicDataSource;
    }

    @Bean
    public IDBRouterStrategy dbRouterStrategy(DBRouterConfig dbRouterConfig) {
        return new DBRouterStrategyHashCode(dbRouterConfig);
    }

    @Bean
    public TransactionTemplate transactionTemplate(DataSource mysqlDataSource) {
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
        dataSourceTransactionManager.setDataSource(mysqlDataSource);
        TransactionTemplate transactionTemplate = new TransactionTemplate();
        transactionTemplate.setTransactionManager((PlatformTransactionManager)dataSourceTransactionManager);
        transactionTemplate.setPropagationBehaviorName("PROPAGATION_REQUIRED");
        return transactionTemplate;
    }

    public void setEnvironment(Environment environment) {
        String prefix = "mini-db-router.jdbc.datasource.";
        this.dbCount = Integer.parseInt(Objects.requireNonNull(environment.getProperty(prefix + "dbCount")));
        this.tbCount = Integer.parseInt(Objects.requireNonNull(environment.getProperty(prefix + "tbCount")));
        this.routerKey = environment.getProperty(prefix + "routerKey");
        String dataSources = environment.getProperty(prefix + "list");
        Map<String, Object> globalInfo = this.getGlobalProps(environment, prefix + TAG_GLOBAL);
        for (String dbInfo : dataSources.split(",")) {
            String dbPrefix = prefix + dbInfo;
            Map dataSourceProps = PropertyUtil.handle(environment, dbPrefix, Map.class);
            this.injectGlobal(dataSourceProps, globalInfo);
            this.dataSourceMap.put(dbInfo, dataSourceProps);
        }
        String defaultData = environment.getProperty(prefix + "default");
        this.defaultDataSourceConfig = PropertyUtil.handle(environment, prefix + defaultData, Map.class);
        this.injectGlobal(this.defaultDataSourceConfig, globalInfo);
    }

    private Map<String, Object> getGlobalProps(Environment environment, String key) {
        try {
            return PropertyUtil.handle(environment, key, Map.class);
        }
        catch (Exception e) {
            return Collections.EMPTY_MAP;
        }
    }

    private void injectGlobal(Map<String, Object> origin, Map<String, Object> global) {
        for (String key : global.keySet()) {
            if (!origin.containsKey(key)) {
                origin.put(key, global.get(key));
                continue;
            }
            if (!(origin.get(key) instanceof Map)) continue;
            this.injectGlobal((Map)origin.get(key), (Map)global.get(key));
        }
    }
}

