/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.db.router.strategy.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.gaga.middleware.db.router.DBContextHolder;
import plus.gaga.middleware.db.router.DBRouterConfig;
import plus.gaga.middleware.db.router.strategy.IDBRouterStrategy;

public class DBRouterStrategyHashCode
implements IDBRouterStrategy {
    private final Logger logger = LoggerFactory.getLogger(DBRouterStrategyHashCode.class);
    private final DBRouterConfig dbRouterConfig;

    public DBRouterStrategyHashCode(DBRouterConfig dbRouterConfig) {
        this.dbRouterConfig = dbRouterConfig;
    }

    @Override
    public void doRouter(String dbKeyAttr) {
        int size = this.dbRouterConfig.getDbCount() * this.dbRouterConfig.getTbCount();
        int idx = size - 1 & (dbKeyAttr.hashCode() ^ dbKeyAttr.hashCode() >>> 16);
        int dbIdx = idx / this.dbRouterConfig.getTbCount() + 1;
        int tbIdx = idx - this.dbRouterConfig.getTbCount() * (dbIdx - 1);
        DBContextHolder.setDBKey(String.format("%02d", dbIdx));
        DBContextHolder.setTBKey(String.format("%03d", tbIdx));
        this.logger.debug("\u6570\u636e\u5e93\u8def\u7531 dbIdx\uff1a{} tbIdx\uff1a{}", (Object)dbIdx, (Object)tbIdx);
    }

    @Override
    public void setDBKey(int dbIdx) {
        DBContextHolder.setDBKey(String.format("%02d", dbIdx));
    }

    @Override
    public void setTBKey(int tbIdx) {
        DBContextHolder.setTBKey(String.format("%03d", tbIdx));
    }

    @Override
    public int dbCount() {
        return this.dbRouterConfig.getDbCount();
    }

    @Override
    public int tbCount() {
        return this.dbRouterConfig.getTbCount();
    }

    @Override
    public void clear() {
        DBContextHolder.clearDBKey();
        DBContextHolder.clearTBKey();
    }
}

