/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathFilter;
import com.alibaba.fastjson2.JSONPathSegment;
import com.alibaba.fastjson2.JSONPathSegmentIndex;
import com.alibaba.fastjson2.JSONPathSegmentName;
import com.alibaba.fastjson2.JSONPathSingle;
import com.alibaba.fastjson2.JSONPathTwoSegment;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

final class JSONPathMulti
extends JSONPath {
    final List<JSONPathSegment> segments;
    final boolean ref;
    final boolean extractSupport;

    JSONPathMulti(String path, List<JSONPathSegment> segments, JSONPath.Feature ... features) {
        super(path, features);
        this.segments = segments;
        boolean extractSupport = true;
        boolean ref = true;
        int size = segments.size();
        for (int i = 0; i < size - 1; ++i) {
            JSONPathSegment prev;
            JSONPathSegment segment = segments.get(i);
            if (segment instanceof JSONPathSegmentIndex) {
                if (((JSONPathSegmentIndex)segment).index >= 0) continue;
                extractSupport = false;
                continue;
            }
            if (segment instanceof JSONPathSegmentName) continue;
            ref = false;
            if (i <= 0 || !((prev = segments.get(i - 1)) instanceof JSONPathSegment.CycleNameSegment) || !((JSONPathSegment.CycleNameSegment)prev).shouldRecursive() || !(segment instanceof JSONPathFilter.NameFilter)) break;
            ((JSONPathFilter.NameFilter)segment).excludeArray();
            break;
        }
        this.extractSupport = extractSupport;
        this.ref = ref;
    }

    @Override
    public boolean remove(Object root) {
        JSONPath.Context context = null;
        int size = this.segments.size();
        if (size == 0) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            JSONPathSegment segment = this.segments.get(i);
            JSONPathSegment nextSegment = null;
            int nextIndex = i + 1;
            if (nextIndex < size) {
                nextSegment = this.segments.get(nextIndex);
            }
            context = new JSONPath.Context(this, context, segment, nextSegment, 0L);
            if (i == 0) {
                context.root = root;
            }
            if (i == size - 1) {
                return segment.remove(context);
            }
            segment.eval(context);
            if (context.value != null) continue;
            return false;
        }
        return false;
    }

    @Override
    public boolean contains(Object root) {
        JSONPath.Context context = null;
        int size = this.segments.size();
        if (size == 0) {
            return root != null;
        }
        for (int i = 0; i < size; ++i) {
            JSONPathSegment segment = this.segments.get(i);
            JSONPathSegment nextSegment = null;
            int nextIndex = i + 1;
            if (nextIndex < size) {
                nextSegment = this.segments.get(nextIndex);
            }
            context = new JSONPath.Context(this, context, segment, nextSegment, 0L);
            if (i == 0) {
                context.root = root;
            }
            if (i == size - 1) {
                return segment.contains(context);
            }
            segment.eval(context);
        }
        return false;
    }

    @Override
    public boolean endsWithFilter() {
        int size = this.segments.size();
        JSONPathSegment last = this.segments.get(size - 1);
        return last instanceof JSONPathFilter;
    }

    @Override
    public JSONPath getParent() {
        int size = this.segments.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return JSONPath.RootPath.INSTANCE;
        }
        if (size == 2) {
            return JSONPathSingle.of(this.segments.get(0));
        }
        StringBuilder buf = new StringBuilder();
        buf.append('$');
        ArrayList<JSONPathSegment> parentSegments = new ArrayList<JSONPathSegment>(size - 1);
        int end = size - 1;
        for (int i = 0; i < end; ++i) {
            boolean array;
            JSONPathSegment segment = this.segments.get(i);
            parentSegments.add(segment);
            boolean bl = array = segment instanceof JSONPathSegmentIndex || segment instanceof JSONPathSegment.MultiIndexSegment || segment instanceof JSONPathFilter;
            if (!array) {
                buf.append('.');
            }
            buf.append(segment);
        }
        String parentPath = buf.toString();
        if (size == 3) {
            new JSONPathTwoSegment(parentPath, this.segments.get(0), this.segments.get(1), new JSONPath.Feature[0]);
        }
        return new JSONPathMulti(parentPath, parentSegments, new JSONPath.Feature[0]);
    }

    @Override
    public boolean isRef() {
        return this.ref;
    }

    @Override
    public Object eval(Object root) {
        JSONPath.Context context = null;
        int size = this.segments.size();
        if (size == 0) {
            return root;
        }
        for (int i = 0; i < size; ++i) {
            JSONPathSegment prev;
            JSONPathSegment segment = this.segments.get(i);
            JSONPathSegment nextSegment = null;
            int nextIndex = i + 1;
            if (nextIndex < size) {
                nextSegment = this.segments.get(nextIndex);
            }
            context = new JSONPath.Context(this, context, segment, nextSegment, 0L);
            if (i == 0) {
                context.root = root;
            }
            if (i > 0 && (prev = this.segments.get(i - 1)) instanceof JSONPathSegment.CycleNameSegment && ((JSONPathSegment.CycleNameSegment)prev).shouldRecursive() && segment instanceof JSONPathFilter.NameFilter) {
                ((JSONPathFilter.NameFilter)segment).excludeArray();
            }
            segment.eval(context);
        }
        Object contextValue = context.value;
        if ((context.path.features & JSONPath.Feature.AlwaysReturnList.mask) != 0L) {
            if (contextValue == null) {
                contextValue = new JSONArray();
            } else if (!(contextValue instanceof List)) {
                contextValue = JSONArray.of(contextValue);
            }
        }
        return contextValue;
    }

    @Override
    public void set(Object root, Object value) {
        JSONPath.Context context = null;
        int size = this.segments.size();
        for (int i = 0; i < size - 1; ++i) {
            FieldReader fieldReader;
            Cloneable emptyValue;
            JSONPathSegment segment = this.segments.get(i);
            JSONPathSegment nextSegment = null;
            int nextIndex = i + 1;
            if (nextIndex < size) {
                nextSegment = this.segments.get(nextIndex);
            }
            context = new JSONPath.Context(this, context, segment, nextSegment, 0L);
            if (i == 0) {
                context.root = root;
            }
            segment.eval(context);
            if (context.value != null || nextSegment == null) continue;
            if (value == null) {
                return;
            }
            Object parentObject = i == 0 ? root : context.parent.value;
            if (nextSegment instanceof JSONPathSegmentIndex) {
                emptyValue = new JSONArray();
            } else if (nextSegment instanceof JSONPathSegmentName) {
                emptyValue = new JSONObject();
            } else {
                return;
            }
            context.value = emptyValue;
            if (parentObject instanceof Map && segment instanceof JSONPathSegmentName) {
                ((Map)parentObject).put(((JSONPathSegmentName)segment).name, emptyValue);
                continue;
            }
            if (parentObject instanceof List && segment instanceof JSONPathSegmentIndex) {
                int index = ((JSONPathSegmentIndex)segment).index;
                List list = (List)parentObject;
                if (index == list.size()) {
                    list.add(emptyValue);
                    continue;
                }
                list.set(index, emptyValue);
                continue;
            }
            if (parentObject == null) continue;
            Class<?> parentObjectClass = parentObject.getClass();
            JSONReader.Context readerContext = this.getReaderContext();
            ObjectReader objectReader = readerContext.getObjectReader(parentObjectClass);
            if (!(segment instanceof JSONPathSegmentName) || (fieldReader = objectReader.getFieldReader(((JSONPathSegmentName)segment).nameHashCode)) == null) continue;
            ObjectReader fieldObjectReader = fieldReader.getObjectReader(readerContext);
            Object fieldValue = fieldObjectReader.createInstance();
            fieldReader.accept(parentObject, fieldValue);
            context.value = fieldValue;
        }
        context = new JSONPath.Context(this, context, this.segments.get(0), null, 0L);
        context.root = root;
        JSONPathSegment segment = this.segments.get(size - 1);
        segment.set(context, value);
    }

    @Override
    public void set(Object root, Object value, JSONReader.Feature ... readerFeatures) {
        long features = 0L;
        for (JSONReader.Feature feature : readerFeatures) {
            features |= feature.mask;
        }
        JSONPath.Context context = null;
        int size = this.segments.size();
        for (int i = 0; i < size - 1; ++i) {
            JSONPathSegment segment = this.segments.get(i);
            JSONPathSegment nextSegment = null;
            int nextIndex = i + 1;
            if (nextIndex < size) {
                nextSegment = this.segments.get(nextIndex);
            }
            context = new JSONPath.Context(this, context, segment, nextSegment, features);
            if (i == 0) {
                context.root = root;
            }
            segment.eval(context);
        }
        context = new JSONPath.Context(this, context, this.segments.get(0), null, features);
        context.root = root;
        JSONPathSegment segment = this.segments.get(size - 1);
        segment.set(context, value);
    }

    @Override
    public void setCallback(Object root, BiFunction callback) {
        JSONPath.Context context = null;
        int size = this.segments.size();
        for (int i = 0; i < size - 1; ++i) {
            JSONPathSegment segment = this.segments.get(i);
            JSONPathSegment nextSegment = null;
            int nextIndex = i + 1;
            if (nextIndex < size) {
                nextSegment = this.segments.get(nextIndex);
            }
            context = new JSONPath.Context(this, context, segment, nextSegment, 0L);
            if (i == 0) {
                context.root = root;
            }
            segment.eval(context);
        }
        context = new JSONPath.Context(this, context, this.segments.get(0), null, 0L);
        context.root = root;
        JSONPathSegment segment = this.segments.get(size - 1);
        segment.setCallback(context, callback);
    }

    @Override
    public void setInt(Object rootObject, int value) {
        this.set(rootObject, value);
    }

    @Override
    public void setLong(Object rootObject, long value) {
        this.set(rootObject, value);
    }

    @Override
    public Object extract(JSONReader jsonReader) {
        Object value;
        if (jsonReader == null) {
            return null;
        }
        int size = this.segments.size();
        if (size == 0) {
            return null;
        }
        if (!this.extractSupport) {
            Object root = jsonReader.readAny();
            return this.eval(root);
        }
        boolean eval = false;
        JSONPath.Context context = null;
        for (int i = 0; i < size; ++i) {
            JSONPathSegment segment = this.segments.get(i);
            JSONPathSegment nextSegment = null;
            int nextIndex = i + 1;
            if (nextIndex < size) {
                nextSegment = this.segments.get(nextIndex);
            }
            context = new JSONPath.Context(this, context, segment, nextSegment, 0L);
            if (eval) {
                segment.eval(context);
            } else {
                segment.accept(jsonReader, context);
            }
            if (!context.eval) continue;
            eval = true;
            if (context.value == null) break;
        }
        if ((value = context.value) instanceof JSONPath.Sequence) {
            value = ((JSONPath.Sequence)value).values;
        }
        if ((this.features & JSONPath.Feature.AlwaysReturnList.mask) != 0L) {
            if (value == null) {
                value = new JSONArray();
            } else if (!(value instanceof List)) {
                value = JSONArray.of(value);
            }
        }
        return value;
    }

    @Override
    public String extractScalar(JSONReader jsonReader) {
        int size = this.segments.size();
        if (size == 0) {
            return null;
        }
        boolean eval = false;
        JSONPath.Context context = null;
        for (int i = 0; i < size; ++i) {
            JSONPathSegment segment = this.segments.get(i);
            JSONPathSegment nextSegment = null;
            int nextIndex = i + 1;
            if (nextIndex < size) {
                nextSegment = this.segments.get(nextIndex);
            }
            context = new JSONPath.Context(this, context, segment, nextSegment, 0L);
            if (eval) {
                segment.eval(context);
            } else {
                segment.accept(jsonReader, context);
            }
            if (!context.eval) continue;
            eval = true;
            if (context.value == null) break;
        }
        return JSON.toJSONString(context.value);
    }
}

