/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.sdk.domain.service.impl;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.gaga.middleware.sdk.domain.service.IOpenAiCodeReviewService;
import plus.gaga.middleware.sdk.infrastructure.git.GitCommand;
import plus.gaga.middleware.sdk.infrastructure.openai.IOpenAI;
import plus.gaga.middleware.sdk.infrastructure.weixin.WeiXin;

public abstract class AbstractOpenAiCodeReviewService
implements IOpenAiCodeReviewService {
    private final Logger logger = LoggerFactory.getLogger(AbstractOpenAiCodeReviewService.class);
    protected final GitCommand gitCommand;
    protected final IOpenAI openAI;
    protected final WeiXin weiXin;

    public AbstractOpenAiCodeReviewService(GitCommand gitCommand, IOpenAI openAI, WeiXin weiXin) {
        this.gitCommand = gitCommand;
        this.openAI = openAI;
        this.weiXin = weiXin;
    }

    @Override
    public void exec() {
        try {
            String diffCode = this.getDiffCode();
            String recommend = this.codeReview(diffCode);
            String logUrl = this.recordCodeReview(recommend);
            this.pushMessage(logUrl);
        }
        catch (Exception e) {
            this.logger.info("openai-code-review error", e);
        }
    }

    protected abstract String getDiffCode() throws IOException, InterruptedException;

    protected abstract String codeReview(String var1) throws IOException;

    protected abstract String recordCodeReview(String var1);

    protected abstract void pushMessage(String var1) throws IOException;
}

