/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.sdk.domain.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plus.gaga.middleware.sdk.domain.model.Model;
import plus.gaga.middleware.sdk.domain.service.impl.AbstractOpenAiCodeReviewService;
import plus.gaga.middleware.sdk.infrastructure.git.GitCommand;
import plus.gaga.middleware.sdk.infrastructure.openai.IOpenAI;
import plus.gaga.middleware.sdk.infrastructure.openai.dto.ChatCompletionRequestDTO;
import plus.gaga.middleware.sdk.infrastructure.openai.dto.ChatCompletionSyncResponseDTO;
import plus.gaga.middleware.sdk.infrastructure.weixin.WeiXin;
import plus.gaga.middleware.sdk.infrastructure.weixin.dto.TemplateMessageDTO;

public class OpenAiCodeReviewService
extends AbstractOpenAiCodeReviewService {
    public OpenAiCodeReviewService(GitCommand gitCommand, IOpenAI openAI, WeiXin weiXin) {
        super(gitCommand, openAI, weiXin);
    }

    @Override
    protected String getDiffCode() throws IOException, InterruptedException {
        return this.gitCommand.diff();
    }

    @Override
    protected String codeReview(final String diffCode) throws IOException {
        ChatCompletionRequestDTO chatCompletionRequest = new ChatCompletionRequestDTO();
        chatCompletionRequest.setModel(Model.GLM_4_FLASH.getCode());
        chatCompletionRequest.setMessages((List<ChatCompletionRequestDTO.Prompt>)new ArrayList<ChatCompletionRequestDTO.Prompt>(){
            private static final long serialVersionUID = -7988151926241837899L;
            {
                this.add(new ChatCompletionRequestDTO.Prompt("user", "\u4f60\u662f\u4e00\u4e2a\u9ad8\u7ea7\u7f16\u7a0b\u67b6\u6784\u5e08\uff0c\u7cbe\u901a\u5404\u7c7b\u573a\u666f\u65b9\u6848\u3001\u67b6\u6784\u8bbe\u8ba1\u548c\u7f16\u7a0b\u8bed\u8a00\u8bf7\uff0c\u8bf7\u60a8\u6839\u636egit diff\u8bb0\u5f55\uff0c\u5bf9\u4ee3\u7801\u505a\u51fa\u8bc4\u5ba1\u3002\u4ee3\u7801\u5982\u4e0b:"));
                this.add(new ChatCompletionRequestDTO.Prompt("user", diffCode));
            }
        });
        ChatCompletionSyncResponseDTO completions = this.openAI.completions(chatCompletionRequest);
        ChatCompletionSyncResponseDTO.Message message = completions.getChoices().get(0).getMessage();
        return message.getContent();
    }

    @Override
    protected String recordCodeReview(String recommend) {
        return this.gitCommand.commitAndPush(recommend);
    }

    @Override
    protected void pushMessage(String logUrl) throws IOException {
        HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
        TemplateMessageDTO.put(data, TemplateMessageDTO.TemplateKey.REPO_NAME, this.gitCommand.getProject());
        TemplateMessageDTO.put(data, TemplateMessageDTO.TemplateKey.BRANCH_NAME, this.gitCommand.getBranch());
        TemplateMessageDTO.put(data, TemplateMessageDTO.TemplateKey.COMMIT_AUTHOR, this.gitCommand.getAuthor());
        TemplateMessageDTO.put(data, TemplateMessageDTO.TemplateKey.COMMIT_MESSAGE, this.gitCommand.getMessage());
        this.weiXin.sendTemplateMessage(logUrl, data);
    }
}

