/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.sdk.infrastructure.git;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.gaga.middleware.sdk.types.utils.RandomStringUtils;

public class GitCommand {
    private final Logger logger = LoggerFactory.getLogger(GitCommand.class);
    private final String githubReviewLogUri;
    private final String githubToken;
    private final String project;
    private final String branch;
    private final String author;
    private final String message;

    public GitCommand(String githubReviewLogUri, String githubToken, String project, String branch, String author, String message) {
        this.githubReviewLogUri = githubReviewLogUri;
        this.githubToken = githubToken;
        this.project = project;
        this.branch = branch;
        this.author = author;
        this.message = message;
    }

    public String diff() throws IOException, InterruptedException {
        String line;
        ProcessBuilder processBuilder = new ProcessBuilder("git", "diff", "HEAD~1", "HEAD");
        processBuilder.directory(new File("."));
        Process process = processBuilder.start();
        StringBuilder diffCode = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            diffCode.append(line);
        }
        int exitCode = process.waitFor();
        this.logger.info("openai-code-review git diff done! {}", (Object)exitCode);
        return diffCode.toString();
    }

    public String commitAndPush(String recommend) {
        try {
            Git git = ((CloneCommand)Git.cloneRepository().setURI(this.githubReviewLogUri + ".git").setDirectory(new File("repo")).setCredentialsProvider(new UsernamePasswordCredentialsProvider(this.githubToken, ""))).call();
            String dateFolderName = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            File dateFolder = new File("repo/" + dateFolderName);
            if (!dateFolder.exists()) {
                dateFolder.mkdirs();
            }
            String fileName = this.project + "-" + this.branch + "_" + this.author + "_" + System.currentTimeMillis() + "_" + RandomStringUtils.randomNumeric(4) + ".md";
            File newFile = new File(dateFolder, fileName);
            try (FileWriter writer = new FileWriter(newFile);){
                writer.write(recommend);
            }
            git.add().addFilepattern(dateFolderName + "/" + fileName).call();
            git.commit().setMessage("add code review new file" + fileName).call();
            ((PushCommand)git.push().setCredentialsProvider(new UsernamePasswordCredentialsProvider(this.githubToken, ""))).call();
            this.logger.info("openai-code-review git commit and push done! {}", (Object)fileName);
            return this.githubReviewLogUri + "/blob/master/" + dateFolderName + "/" + fileName;
        }
        catch (IOException | GitAPIException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getGithubReviewLogUri() {
        return this.githubReviewLogUri;
    }

    public String getGithubToken() {
        return this.githubToken;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getMessage() {
        return this.message;
    }
}

