/*
 * Decompiled with CFR 0.152.
 */
package plus.gaga.middleware.sdk.types.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class BearerTokenUtils {
    private static final long expireMillis = 1800000L;
    public static Cache<String, String> cache = CacheBuilder.newBuilder().expireAfterWrite(1740000L, TimeUnit.MILLISECONDS).build();

    public static String getToken(String apiKeySecret) {
        String[] split = apiKeySecret.split("\\.");
        return BearerTokenUtils.getToken(split[0], split[1]);
    }

    public static String getToken(String apiKey, String apiSecret) {
        String token = cache.getIfPresent(apiKey);
        if (null != token) {
            return token;
        }
        Algorithm algorithm = Algorithm.HMAC256(apiSecret.getBytes(StandardCharsets.UTF_8));
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("api_key", apiKey);
        payload.put("exp", System.currentTimeMillis() + 1800000L);
        payload.put("timestamp", Calendar.getInstance().getTimeInMillis());
        HashMap<String, Object> headerClaims = new HashMap<String, Object>();
        headerClaims.put("alg", "HS256");
        headerClaims.put("sign_type", "SIGN");
        token = JWT.create().withPayload(payload).withHeader(headerClaims).sign(algorithm);
        cache.put(apiKey, token);
        return token;
    }
}

