/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.annotation;

import java.lang.annotation.*;

/**
 * Redis限流注解
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Target(ElementType.METHOD) // 作用于方法上
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RateLimiter {
    /**
     * 自定义限流切入点 name 默认类引用路径+方法名
     */
    String name() default "";

    /**
     * 限流速率（时间间隔内最大请求个数）
     */
    long rate() default 5;

    /**
     * 速率间隔 单位毫秒
     */
    long rateInterval() default 1000;

    /**
     * 是否启用IP限流（加上IP作为name标识）
     */
    boolean ipLimit() default false;
}
