/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.base;

import jodd.bean.BeanCopy;
import plus.hiver.common.exception.HiverException;

/**
 * 基础实体转换
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface HiverBeanConvert {
    /**
     * 获取自动转换后的JavaBean对象
     *
     * @param clazz 转换对象类
     * @param <T>   转换对象
     * @return T 待转换对象
     */
    default <T> T convert(Class<T> clazz) {
        try {
            T t = clazz.getDeclaredConstructor().newInstance();
            new BeanCopy(this, t).copy();
            return t;
        } catch (Exception e) {
            throw new HiverException("转换对象失败", e);
        }
    }
}
