/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.interceptor;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import plus.hiver.common.config.properties.IgnoredUrlsProperties;

/**
 * 拦截器配置
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Configuration
public class InterceptorConfiguration implements WebMvcConfigurer {
    @Autowired
    private IgnoredUrlsProperties ignoredUrlsProperties;

    @Autowired
    private LimitRaterInterceptor limitRaterInterceptor;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        // 注册拦截器
        // 配置拦截的路径
        // 配置不拦截的路径 避免加载css也拦截（可根据实际情况放开限流配置或拦截路径）
        registry.addInterceptor(limitRaterInterceptor)
                .addPathPatterns("/**")
                .excludePathPatterns(ignoredUrlsProperties.getLimitUrls());
        // 增加license拦截器
        // registry.addInterceptor(licenseCheckInterceptor);
    }
}
