/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.mybatisplus;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import plus.hiver.common.config.security.SecurityUserDetails;

import java.util.Date;

/**
 * 字段填充审计
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@Component
public class MyMetaObjectHandler implements MetaObjectHandler {
    @Override
    public void insertFill(MetaObject metaObject) {
        SecurityUserDetails userDetails = getFieldUser(metaObject);
        if (null != userDetails) {
            this.setFieldValByName("createBy", userDetails.getUsername(), metaObject);
            this.setFieldValByName("createId", userDetails.getId(), metaObject);
        }
        this.setFieldValByName("createTime", new Date(), metaObject);
        this.setFieldValByName("deleted", 0, metaObject);
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        SecurityUserDetails userDetails = getFieldUser(metaObject);
        if (null != userDetails) {
            this.setFieldValByName("updateBy", userDetails.getUsername(), metaObject);
        }
        this.setFieldValByName("updateTime", new Date(), metaObject);
    }

    public SecurityUserDetails getFieldUser(MetaObject metaObject) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getName() != null
                && !(authentication instanceof AnonymousAuthenticationToken)) {
            Object principal = authentication.getPrincipal();
            if (principal instanceof UserDetails) {
                UserDetails userDetails = (UserDetails) principal;
                SecurityUserDetails securityUserDetails = ((SecurityUserDetails) userDetails);
                return securityUserDetails;
            }
        }
        return null;
    }
}
