/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.mybatisplus;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import plus.hiver.common.config.interceptor.PerformanceInterceptor;
import plus.hiver.common.config.mybatisplus.mapper.HiverSqlInjector;

import java.util.List;

/**
 * MyBatis Plus配置
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Lazy
@EnableTransactionManagement
@Configuration(proxyBeanMethods = false)
@MapperScan({"plus.hiver.*.dao", "plus.hiver.*.mapper", "plus.hiver.*.dao.mapper"})
public class MybatisPlusConfig {
    /**
     * 新的分页插件
     */
    @Bean
    @ConditionalOnMissingBean
    public MybatisPlusInterceptor mybatisPlusInterceptor(@Autowired(required = false) List<InnerInterceptor> innerInterceptorList) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        if (CollectionUtils.isNotEmpty(innerInterceptorList)) {
            // 注入自定义插件
            innerInterceptorList.forEach(i -> interceptor.addInnerInterceptor(i));
        }
        interceptor.addInnerInterceptor(new PaginationInnerInterceptor(DbType.POSTGRE_SQL));
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public HiverSqlInjector batchSqlInjector() {
        return new HiverSqlInjector();
    }

    @Bean
    @ConditionalOnMissingBean
    public MyMetaObjectHandler metaObjectHandler() {
        return new MyMetaObjectHandler();
    }

    @Bean
    @ConditionalOnProperty(prefix = "mybatis-plus", name = "sql-print", havingValue = "true")
    public PerformanceInterceptor performanceInterceptor() {
        return new PerformanceInterceptor();
    }
}
