/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.mybatisplus.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;
import java.util.Map;

/**
 * SQL Mapper 接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface SqlMapper {
    @Select("${sql}")
    Page<Map<String, Object>> selectPageBySql(IPage<Object> page, @Param("sql") String sql, @Param("params") Map<String, Object> params);

    @Select("${sql}")
    List<Map<String, Object>> selectListBySql(@Param("sql") String sql, @Param("params") Map<String, Object> params);

    @Select("${sql}")
    Map<String, Object> selectOneBySql(@Param("sql") String sql, @Param("params") Map<String, Object> params);

    @Update("${sql}")
    Integer updateBySql(@Param("sql") String sql, @Param("params") Map<String, Object> params);

    @Delete("${sql}")
    Integer deleteBySql(@Param("sql") String sql, @Param("params") Map<String, Object> params);
}
