/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.dao;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.entity.DepartmentHeader;

import java.util.List;

/**
 * 部门负责人数据处理层
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface DepartmentHeaderDao extends HiverBaseDao<DepartmentHeader, Long> {
    /**
     * 通过部门和负责人类型获取
     */
    List<DepartmentHeader> findByDepartmentIdAndType(Long departmentId, Integer type);

    /**
     * 通过部门获取
     */
    List<DepartmentHeader> findByDepartmentIdIn(List<Long> departmentIds);

    /**
     * 通过部门id删除
     */
    @Modifying
    @Query("delete from DepartmentHeader d where d.departmentId = ?1")
    void deleteByDepartmentId(Long departmentId);

    /**
     * 通过userId删除
     */
    @Modifying
    @Query("delete from DepartmentHeader d where d.userId = ?1")
    void deleteByUserId(Long userId);

    /**
     * 通过部门id和userId类型获取
     */
    List<DepartmentHeader> findByUserIdAndDepartmentId(Long userId, Long departmentId);

    /**
     * 通过部门和负责人类型获取
     */
    List<DepartmentHeader> findByDepartmentId(Long departmentId);
}
