/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.dao;

import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.entity.Role;

import java.util.List;

/**
 * 角色数据处理层
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface RoleDao extends HiverBaseDao<Role, Long> {
    /**
     * 获取默认角色
     */
    List<Role> findByDefaultRole(Boolean defaultRole);

    /**
     * 获得所有角色
     */
    List<Role> findByDeleted(Integer deleted);
}
