/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.dao;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.entity.RoleDepartment;

import java.util.List;

/**
 * 角色部门数据处理层
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface RoleDepartmentDao extends HiverBaseDao<RoleDepartment, Long> {
    /**
     * 通过roleId获取
     */
    List<RoleDepartment> findByRoleId(Long roleId);

    /**
     * 通过角色id删除
     */
    @Modifying
    @Query("delete from RoleDepartment r where r.roleId = ?1")
    void deleteByRoleId(Long roleId);

    /**
     * 通过角色id删除
     */
    @Modifying
    @Query("delete from RoleDepartment r where r.departmentId = ?1")
    void deleteByDepartmentId(Long departmentId);
}
