/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.dao;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.entity.RolePermission;

import java.util.List;

/**
 * 角色权限数据处理层
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface RolePermissionDao extends HiverBaseDao<RolePermission, Long> {
    /**
     * 通过permissionId获取
     */
    List<RolePermission> findByPermissionId(Long permissionId);

    /**
     * 通过roleId获取
     */
    List<RolePermission> findByRoleId(Long roleId);

    /**
     * 通过roleId删除
     */
    @Modifying
    @Query("delete from RolePermission r where r.roleId = ?1")
    void deleteByRoleId(Long roleId);
}
