/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.dao.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import plus.hiver.common.entity.Role;
import plus.hiver.common.entity.UserRole;

import java.util.List;

/**
 * 用户角色映射
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface UserRoleMapper extends BaseMapper<UserRole> {
    /**
     * 通过用户id获取
     */
    List<Role> findByUserId(@Param("userId") Long userId);

    /**
     * 通过用户id获取用户角色关联的部门数据
     */
    List<Long> findDepIdsByUserId(@Param("userId") Long userId);
}
