/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.exception;

import lombok.Data;
import plus.hiver.common.api.IErrorCode;

/**
 * 自定义异常类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
public class HiverException extends RuntimeException {
    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = -5885155226898287919L;

    /**
     * 错误码
     */
    private IErrorCode errorCode;

    public HiverException(IErrorCode errorCode) {
        super(errorCode.getMsg());
        this.errorCode = errorCode;
    }

    private String msg;

    public HiverException(String msg) {
        super(msg);
        this.msg = msg;
    }

    public HiverException(String message, Throwable cause) {
        super(message, cause);
    }
}
