/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.lock;

/**
 * 回调函数接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface Callback {
    /**
     * 成功获取锁后执行方法
     *
     * @return 返回值
     * @throws InterruptedException 中断异常
     */
    Object onGetLock() throws InterruptedException;

    /**
     * 获取锁超时回调
     *
     * @return 返回值
     * @throws InterruptedException 中断异常
     */
    Object onTimeout() throws InterruptedException;
}
