/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.service;

import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.entity.Department;

import java.util.List;

/**
 * 部门接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface DepartmentService extends HiverBaseService<Department, Long> {
    /**
     * 通过父id获取 升序
     */
    List<Department> findByParentIdOrderBySortOrder(Long parentId, Boolean openDataFilter);

    /**
     * 通过父id和状态获取
     */
    List<Department> findByParentIdAndStatusOrderBySortOrder(Long parentId, Integer status);

    /**
     * 部门名模糊搜索 升序
     */
    List<Department> findByTitleLikeOrderBySortOrder(String title, Boolean openDataFilter);

    /**
     * 获得该部门的上级所有部门
     */
    List<Department> findDepartmentAllById(Long id);

    /**
     * 获得全部部门
     */
    List<Department> findByDeletedAndStatus(Integer deleted, Integer status);

    /**
     * 根据父节点获得部门列表
     */
    List<Department> findByDeletedAndStatusAndParentId(Integer deleted, Integer status, Long parentId);
}
