/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.service;

import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.entity.RolePermission;

import java.util.List;

/**
 * 角色权限接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface RolePermissionService extends HiverBaseService<RolePermission, Long> {
    /**
     * 通过permissionId获取
     */
    List<RolePermission> findByPermissionId(Long permissionId);

    /**
     * 通过roleId获取
     */
    List<RolePermission> findByRoleId(Long roleId);

    /**
     * 通过roleId删除
     */
    void deleteByRoleId(Long roleId);
}
