/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.service;

import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import plus.hiver.common.entity.Setting;

/**
 * 配置接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@CacheConfig(cacheNames = "setting")
public interface SettingService {
    /**
     * 通过id获取
     */
    @Cacheable(key = "#key")
    Setting get(String key);

    /**
     * 修改
     */
    @CacheEvict(key = "#setting.key")
    Setting saveOrUpdate(Setting setting);
}
