/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.serviceimpl;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.dao.SettingDao;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.service.SettingService;

/**
 * 配置接口实现
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@Service
@Transactional
public class SettingServiceImpl implements SettingService {
    @Autowired
    private SettingDao settingDao;

    @Override
    public Setting get(String key) {
        return settingDao.findByKey(key);
    }

    @Override
    public Setting saveOrUpdate(Setting setting) {
        return settingDao.saveAndFlush(setting);
    }
}
