/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.utils;

import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public class ObjectUtil {
    /**
     * 屏蔽字段
     */
    public static final String SCRECT_FIELDS[] = {"password", "accessToken", "appToken"};

    public static String mapToString(Map<String, String[]> paramMap) {
        if (paramMap == null) {
            return "";
        }
        Map<String, Object> params = new HashMap<>(16);
        for (Map.Entry<String, String[]> param : paramMap.entrySet()) {

            String key = param.getKey();
            String paramValue = (param.getValue() != null && param.getValue().length > 0 ? param.getValue()[0] : "");
            String obj = StrUtil.endWithAnyIgnoreCase(param.getKey(), SCRECT_FIELDS) ? "***" : paramValue;
            params.put(key, obj);
        }
        return new Gson().toJson(params);
    }
}
