/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.vo;

import cn.hutool.core.util.StrUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import plus.hiver.common.dto.PermissionDTO;
import plus.hiver.common.dto.RoleDTO;
import plus.hiver.common.entity.User;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 用户令牌（后台）
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@AllArgsConstructor
public class TokenUser implements UserDetails, Serializable {
    private Long appId;

    private Long id;

    private String username;

    private String nickname;

    private String mobile;

    private String email;

    private Long departmentId;

    private Integer type;

    private List<String> permissions;

    private Boolean saveLogin;

    public TokenUser(User user, Boolean storePerms, Boolean saveLogin) {
        this.appId = user.getAppId();
        this.id = user.getId();
        this.username = user.getUsername();
        this.nickname = user.getNickname();
        this.mobile = user.getMobile();
        this.email = user.getEmail();
        this.departmentId = user.getDepartmentId();
        this.type = user.getType();
        this.saveLogin = saveLogin;

        // 缓存权限
        List<String> list = new ArrayList<>();
        if (storePerms) {
            for (PermissionDTO p : user.getPermissions()) {
                if (StrUtil.isNotBlank(p.getTitle()) && StrUtil.isNotBlank(p.getPath())) {
                    list.add(p.getTitle());
                }
            }
            for (RoleDTO r : user.getRoles()) {
                list.add(r.getName());
            }
            this.setPermissions(list);
        }
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return null;
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    public boolean isAccountNonLocked() {
        return true;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}
