/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.base;

import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import plus.hiver.common.base.HiverBaseDao;

@FunctionalInterface
public interface HiverBaseService<E, ID extends Serializable> {
    public HiverBaseDao<E, ID> getRepository();

    default public E get(ID ID) {
        return (E)this.getRepository().getReferenceById(ID);
    }

    default public E findById(ID ID) {
        return this.getRepository().findById(ID).orElse(null);
    }

    default public List<E> getAll() {
        return this.getRepository().findAll();
    }

    default public Long getTotalCount() {
        return this.getRepository().count();
    }

    default public E save(E e) {
        return (E)this.getRepository().save(e);
    }

    default public E update(E e) {
        return (E)this.getRepository().saveAndFlush(e);
    }

    default public Iterable<E> saveOrUpdateAll(Iterable<E> iterable) {
        return this.getRepository().saveAll(iterable);
    }

    default public void delete(E e) {
        this.getRepository().delete(e);
    }

    default public void delete(ID ID) {
        this.getRepository().deleteById(ID);
    }

    default public void deleteAllById(Iterable<ID> iterable) {
        this.getRepository().deleteAllById(iterable);
    }

    default public void delete(Iterable<E> iterable) {
        this.getRepository().deleteAll(iterable);
    }

    default public void flush() {
        this.getRepository().flush();
    }

    default public List<E> findAll(Specification<E> specification) {
        return this.getRepository().findAll(specification);
    }

    default public Page<E> findAll(Pageable pageable) {
        return this.getRepository().findAll(pageable);
    }

    default public Page<E> findAll(Specification<E> specification, Pageable pageable) {
        return this.getRepository().findAll(specification, pageable);
    }

    default public long count(Specification<E> specification) {
        return this.getRepository().count(specification);
    }
}

