/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.cache;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class RedisCacheConfig
extends CachingConfigurerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisCacheConfig.class);
    @Value(value="${hiver.cache.timeToLive:-1}")
    private Duration timeToLive;

    @Bean
    public CacheManager cacheManager(RedisConnectionFactory redisConnectionFactory) {
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.activateDefaultTyping(new ObjectMapper().getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        RedisCacheConfiguration redisCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig().serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)stringRedisSerializer)).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)jackson2JsonRedisSerializer)).disableCachingNullValues();
        RedisCacheManager redisCacheManager = RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(redisCacheConfiguration.entryTtl(this.timeToLive)).build();
        return redisCacheManager;
    }

    public CacheErrorHandler errorHandler() {
        CacheErrorHandler cacheErrorHandler = new CacheErrorHandler(){

            public void handleCacheGetError(RuntimeException runtimeException, Cache cache, Object object) {
                log.warn("Redis occur handleCacheGetError\uff1akey: [{}]", object);
            }

            public void handleCachePutError(RuntimeException runtimeException, Cache cache, Object object, Object object2) {
                log.warn("Redis occur handleCachePutError\uff1akey: [{}]\uff1bvalue: [{}]", object, object2);
            }

            public void handleCacheEvictError(RuntimeException runtimeException, Cache cache, Object object) {
                log.warn("Redis occur handleCacheEvictError\uff1akey: [{}]", object);
            }

            public void handleCacheClearError(RuntimeException runtimeException, Cache cache) {
                log.warn("Redis occur handleCacheClearError");
            }
        };
        return cacheErrorHandler;
    }
}

