/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.interceptor;

import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.Method;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import plus.hiver.common.annotation.RateLimiter;
import plus.hiver.common.config.properties.HiverIpLimitProperties;
import plus.hiver.common.config.properties.HiverLimitProperties;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.limit.RedisRaterLimiter;
import plus.hiver.common.service.SettingService;
import plus.hiver.common.utils.IpInfoUtil;
import plus.hiver.common.vo.OtherSetting;

@Component
public class LimitRaterInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LimitRaterInterceptor.class);
    @Autowired
    private HiverLimitProperties limitProperties;
    @Autowired
    private HiverIpLimitProperties ipLimitProperties;
    @Autowired
    private RedisRaterLimiter redisRaterLimiter;
    @Autowired
    private IpInfoUtil ipInfoUtil;
    @Autowired
    private SettingService settingService;

    public OtherSetting getOtherSetting() {
        Setting setting = this.settingService.get("OTHER_SETTING");
        if (StrUtil.isBlank((CharSequence)setting.getValue())) {
            return null;
        }
        return (OtherSetting)new Gson().fromJson(setting.getValue(), OtherSetting.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws Exception {
        String[] stringArray;
        Serializable serializable;
        String string = IpInfoUtil.getIpAddr(httpServletRequest);
        if (this.ipLimitProperties.getEnable().booleanValue() && !((Boolean)(serializable = this.redisRaterLimiter.acquireByRedis(string, this.ipLimitProperties.getLimit(), this.ipLimitProperties.getTimeout()))).booleanValue()) {
            throw new HiverException("\u4f60\u624b\u901f\u600e\u4e48\u8fd9\u4e48\u5feb\uff0c\u8bf7\u70b9\u6162\u4e00\u70b9");
        }
        if (this.limitProperties.getEnable().booleanValue() && !((Boolean)(serializable = this.redisRaterLimiter.acquireByRedis("HIVER_LIMIT_ALL", this.limitProperties.getLimit(), this.limitProperties.getTimeout()))).booleanValue()) {
            throw new HiverException("\u5f53\u524d\u8bbf\u95ee\u603b\u4eba\u6570\u592a\u591a\u5566\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        serializable = this.getOtherSetting();
        if (serializable != null && StrUtil.isNotBlank((CharSequence)((OtherSetting)serializable).getBlacklist())) {
            for (String object2 : stringArray = ((OtherSetting)serializable).getBlacklist().split("\n")) {
                if (!object2.equals(string)) continue;
                throw new HiverException("\u60a8\u7684IP\u5df2\u88ab\u6dfb\u52a0\u81f3\u9ed1\u540d\u5355\uff0c\u8bf7\u6eda");
            }
        }
        try {
            stringArray = (String[])object;
            String[] stringArray2 = stringArray.getBean();
            Method method = stringArray.getMethod();
            RateLimiter rateLimiter = method.getAnnotation(RateLimiter.class);
            if (rateLimiter != null) {
                void var10_19;
                Boolean bl;
                String string2 = rateLimiter.name();
                Long l = rateLimiter.rate();
                Long l2 = rateLimiter.rateInterval();
                if (StrUtil.isBlank((CharSequence)string2)) {
                    String string3 = StrUtil.subBefore((CharSequence)stringArray2.toString(), (CharSequence)"@", (boolean)false) + "_" + method.getName();
                }
                if (rateLimiter.ipLimit()) {
                    void var10_17;
                    String string4 = (String)var10_17 + "_" + string;
                }
                if (!(bl = this.redisRaterLimiter.acquireByRedis((String)var10_19, l, l2)).booleanValue()) {
                    String string5 = "\u5f53\u524d\u8bbf\u95ee\u4eba\u6570\u592a\u591a\u5566\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
                    if (rateLimiter.ipLimit()) {
                        string5 = "\u4f60\u624b\u901f\u600e\u4e48\u8fd9\u4e48\u5feb\uff0c\u8bf7\u70b9\u6162\u4e00\u70b9";
                    }
                    throw new HiverException(string5);
                }
            }
        }
        catch (HiverException hiverException) {
            throw new HiverException(hiverException.getMsg());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, Exception exception) throws Exception {
    }
}

