/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.interceptor;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.SystemClock;
import java.beans.Statement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import lombok.Generated;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class PerformanceInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PerformanceInterceptor.class);
    private long maxTime = 0L;
    private boolean format = false;
    private boolean writeInLog = false;
    private static final SqlFormatter sqlFormatter = new SqlFormatter();

    public Object intercept(Invocation invocation) throws Throwable {
        int n;
        String string;
        Object object = invocation.getArgs()[0];
        Statement statement = Proxy.isProxyClass(object.getClass()) ? (Statement)SystemMetaObject.forObject((Object)object).getValue("h.statement") : (Statement)object;
        MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
        try {
            statement = (Statement)metaObject.getValue("stmt.statement");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (metaObject.hasGetter("delegate")) {
            try {
                statement = (Statement)metaObject.getValue("delegate");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = null) == null) {
            string = statement.toString();
        }
        if ((n = this.indexOfSqlStart(string = string.replaceAll("[\\s]+", " "))) > 0) {
            string = string.substring(n);
        }
        long l = SystemClock.now();
        Object object2 = invocation.proceed();
        long l2 = SystemClock.now() - l;
        Object object3 = PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject2 = SystemMetaObject.forObject((Object)object3);
        MappedStatement mappedStatement = (MappedStatement)metaObject2.getValue("delegate.mappedStatement");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" Time\uff1a").append(l2);
        stringBuilder.append(" ms - ID\uff1a").append(mappedStatement.getId());
        stringBuilder.append("\n Execute SQL\uff1a").append(PerformanceInterceptor.sqlFormat(string, this.format)).append("\n");
        if (this.isWriteInLog()) {
            if (this.getMaxTime() >= 1L && l2 > this.getMaxTime()) {
                log.error(stringBuilder.toString());
            } else {
                log.debug(stringBuilder.toString());
            }
        } else {
            System.err.println(stringBuilder);
            if (this.getMaxTime() >= 1L && l2 > this.getMaxTime()) {
                throw new RuntimeException(" The SQL execution time is too large, please optimize ! ");
            }
        }
        return object2;
    }

    public Object plugin(Object object) {
        if (object instanceof StatementHandler) {
            return Plugin.wrap((Object)object, (Interceptor)this);
        }
        return object;
    }

    public void setProperties(Properties properties) {
        String string = properties.getProperty("maxTime");
        String string2 = properties.getProperty("format");
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            this.maxTime = Long.parseLong(string);
        }
        if (StringUtils.isNotEmpty((CharSequence)string2)) {
            this.format = Boolean.valueOf(string2);
        }
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public PerformanceInterceptor setMaxTime(long l) {
        this.maxTime = l;
        return this;
    }

    public boolean isFormat() {
        return this.format;
    }

    public PerformanceInterceptor setFormat(boolean bl) {
        this.format = bl;
        return this;
    }

    public boolean isWriteInLog() {
        return this.writeInLog;
    }

    public PerformanceInterceptor setWriteInLog(boolean bl) {
        this.writeInLog = bl;
        return this;
    }

    public Method getMethodRegular(Class<?> clazz, String string) {
        if (Object.class.equals(clazz)) {
            return null;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        return this.getMethodRegular(clazz.getSuperclass(), string);
    }

    private int indexOfSqlStart(String string) {
        String string2 = string.toUpperCase();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(string2.indexOf("SELECT "));
        hashSet.add(string2.indexOf("UPDATE "));
        hashSet.add(string2.indexOf("INSERT "));
        hashSet.add(string2.indexOf("DELETE "));
        hashSet.remove(-1);
        if (CollectionUtils.isEmpty(hashSet)) {
            return -1;
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList, Integer::compareTo);
        return (Integer)arrayList.get(0);
    }

    public static String sqlFormat(String string, boolean bl) {
        if (bl) {
            try {
                return sqlFormatter.format(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    static class SqlFormatter {
        public static final String WHITESPACE = " \n\r\f\t";
        private static final Set<String> BEGIN_CLAUSES = new HashSet<String>();
        private static final Set<String> END_CLAUSES = new HashSet<String>();
        private static final Set<String> LOGICAL = new HashSet<String>();
        private static final Set<String> QUANTIFIERS = new HashSet<String>();
        private static final Set<String> DML = new HashSet<String>();
        private static final Set<String> MISC = new HashSet<String>();
        private static final String INDENT_STRING = "    ";
        private static final String INITIAL = "\n    ";

        SqlFormatter() {
        }

        public String format(String string) {
            return new FormatProcess(string).perform();
        }

        static {
            BEGIN_CLAUSES.add("left");
            BEGIN_CLAUSES.add("right");
            BEGIN_CLAUSES.add("inner");
            BEGIN_CLAUSES.add("outer");
            BEGIN_CLAUSES.add("group");
            BEGIN_CLAUSES.add("order");
            END_CLAUSES.add("where");
            END_CLAUSES.add("set");
            END_CLAUSES.add("having");
            END_CLAUSES.add("join");
            END_CLAUSES.add("from");
            END_CLAUSES.add("by");
            END_CLAUSES.add("join");
            END_CLAUSES.add("into");
            END_CLAUSES.add("union");
            LOGICAL.add("and");
            LOGICAL.add("or");
            LOGICAL.add("when");
            LOGICAL.add("else");
            LOGICAL.add("end");
            QUANTIFIERS.add("in");
            QUANTIFIERS.add("all");
            QUANTIFIERS.add("exists");
            QUANTIFIERS.add("some");
            QUANTIFIERS.add("any");
            DML.add("insert");
            DML.add("update");
            DML.add("delete");
            MISC.add("select");
            MISC.add("on");
        }

        private static class FormatProcess {
            boolean beginLine = true;
            boolean afterBeginBeforeEnd;
            boolean afterByOrSetOrFromOrSelect;
            boolean afterValues;
            boolean afterOn;
            boolean afterBetween;
            boolean afterInsert;
            int inFunction;
            int parensSinceSelect;
            private LinkedList<Integer> parenCounts = new LinkedList();
            private LinkedList<Boolean> afterByOrFromOrSelects = new LinkedList();
            int indent = 1;
            StringBuilder result = new StringBuilder();
            StringTokenizer tokens;
            String lastToken;
            String token;
            String lcToken;

            public FormatProcess(String string) {
                this.tokens = new StringTokenizer(string, "()+*/-=<>'`\"[], \n\r\f\t", true);
            }

            public String perform() {
                this.result.append(SqlFormatter.INITIAL);
                while (this.tokens.hasMoreTokens()) {
                    this.token = this.tokens.nextToken();
                    this.lcToken = this.token.toLowerCase(Locale.ROOT);
                    if ("'".equals(this.token)) {
                        var1_1 = "";
                        do {
                            try {
                                var1_1 = this.tokens.nextToken();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.token = this.token + var1_1;
                        } while (!"'".equals(var1_1) && this.tokens.hasMoreTokens());
                    } else if ("\"".equals(this.token)) {
                        do {
                            var1_1 = this.tokens.nextToken();
                            this.token = this.token + var1_1;
                        } while (!"\"".equals(var1_1));
                    }
                    if (this.afterByOrSetOrFromOrSelect && ",".equals(this.token)) {
                        this.commaAfterByOrFromOrSelect();
                    } else if (this.afterOn && ",".equals(this.token)) {
                        this.commaAfterOn();
                    } else if ("(".equals(this.token)) {
                        this.openParen();
                    } else if (")".equals(this.token)) {
                        this.closeParen();
                    } else if (BEGIN_CLAUSES.contains(this.lcToken)) {
                        this.beginNewClause();
                    } else if (END_CLAUSES.contains(this.lcToken)) {
                        this.endNewClause();
                    } else if ("select".equals(this.lcToken)) {
                        this.select();
                    } else if (DML.contains(this.lcToken)) {
                        this.updateOrInsertOrDelete();
                    } else if ("values".equals(this.lcToken)) {
                        this.values();
                    } else if ("on".equals(this.lcToken)) {
                        this.on();
                    } else if (this.afterBetween && this.lcToken.equals("and")) {
                        this.misc();
                        this.afterBetween = false;
                    } else if (LOGICAL.contains(this.lcToken)) {
                        this.logical();
                    } else if (FormatProcess.isWhitespace(this.token)) {
                        this.white();
                    } else {
                        this.misc();
                    }
                    if (FormatProcess.isWhitespace(this.token)) continue;
                    this.lastToken = this.lcToken;
                }
                return this.result.toString();
            }

            private void commaAfterOn() {
                this.out();
                --this.indent;
                this.newline();
                this.afterOn = false;
                this.afterByOrSetOrFromOrSelect = true;
            }

            private void commaAfterByOrFromOrSelect() {
                this.out();
                this.newline();
            }

            private void logical() {
                if ("end".equals(this.lcToken)) {
                    --this.indent;
                }
                this.newline();
                this.out();
                this.beginLine = false;
            }

            private void on() {
                ++this.indent;
                this.afterOn = true;
                this.newline();
                this.out();
                this.beginLine = false;
            }

            private void misc() {
                this.out();
                if ("between".equals(this.lcToken)) {
                    this.afterBetween = true;
                }
                if (this.afterInsert) {
                    this.newline();
                    this.afterInsert = false;
                } else {
                    this.beginLine = false;
                    if ("case".equals(this.lcToken)) {
                        ++this.indent;
                    }
                }
            }

            private void white() {
                if (!this.beginLine) {
                    this.result.append(" ");
                }
            }

            private void updateOrInsertOrDelete() {
                this.out();
                ++this.indent;
                this.beginLine = false;
                if ("update".equals(this.lcToken)) {
                    this.newline();
                }
                if ("insert".equals(this.lcToken)) {
                    this.afterInsert = true;
                }
            }

            private void select() {
                this.out();
                ++this.indent;
                this.newline();
                this.parenCounts.addLast(this.parensSinceSelect);
                this.afterByOrFromOrSelects.addLast(this.afterByOrSetOrFromOrSelect);
                this.parensSinceSelect = 0;
                this.afterByOrSetOrFromOrSelect = true;
            }

            private void out() {
                this.result.append(this.token);
            }

            private void endNewClause() {
                if (!this.afterBeginBeforeEnd) {
                    --this.indent;
                    if (this.afterOn) {
                        --this.indent;
                        this.afterOn = false;
                    }
                    this.newline();
                }
                this.out();
                if (!"union".equals(this.lcToken)) {
                    ++this.indent;
                }
                this.newline();
                this.afterBeginBeforeEnd = false;
                this.afterByOrSetOrFromOrSelect = "by".equals(this.lcToken) || "set".equals(this.lcToken) || "from".equals(this.lcToken);
            }

            private void beginNewClause() {
                if (!this.afterBeginBeforeEnd) {
                    if (this.afterOn) {
                        --this.indent;
                        this.afterOn = false;
                    }
                    --this.indent;
                    this.newline();
                }
                this.out();
                this.beginLine = false;
                this.afterBeginBeforeEnd = true;
            }

            private void values() {
                --this.indent;
                this.newline();
                this.out();
                ++this.indent;
                this.newline();
                this.afterValues = true;
            }

            private void closeParen() {
                --this.parensSinceSelect;
                if (this.parensSinceSelect < 0) {
                    --this.indent;
                    this.parensSinceSelect = this.parenCounts.removeLast();
                    this.afterByOrSetOrFromOrSelect = this.afterByOrFromOrSelects.removeLast();
                }
                if (this.inFunction > 0) {
                    --this.inFunction;
                    this.out();
                } else {
                    if (!this.afterByOrSetOrFromOrSelect) {
                        --this.indent;
                        this.newline();
                    }
                    this.out();
                }
                this.beginLine = false;
            }

            private void openParen() {
                if (FormatProcess.isFunctionName(this.lastToken) || this.inFunction > 0) {
                    ++this.inFunction;
                }
                this.beginLine = false;
                if (this.inFunction > 0) {
                    this.out();
                } else {
                    this.out();
                    if (!this.afterByOrSetOrFromOrSelect) {
                        ++this.indent;
                        this.newline();
                        this.beginLine = true;
                    }
                }
                ++this.parensSinceSelect;
            }

            private static boolean isFunctionName(String string) {
                char c = string.charAt(0);
                boolean bl = Character.isJavaIdentifierStart(c) || '\"' == c;
                return bl && !LOGICAL.contains(string) && !END_CLAUSES.contains(string) && !QUANTIFIERS.contains(string) && !DML.contains(string) && !MISC.contains(string);
            }

            private static boolean isWhitespace(String string) {
                return SqlFormatter.WHITESPACE.contains(string);
            }

            private void newline() {
                this.result.append("\n");
                for (int i = 0; i < this.indent; ++i) {
                    this.result.append(SqlFormatter.INDENT_STRING);
                }
                this.beginLine = true;
            }
        }
    }
}

