/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.mybatisplus;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import java.util.List;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import plus.hiver.common.config.interceptor.PerformanceInterceptor;
import plus.hiver.common.config.mybatisplus.MyMetaObjectHandler;
import plus.hiver.common.config.mybatisplus.mapper.HiverSqlInjector;

@Lazy
@EnableTransactionManagement
@Configuration(proxyBeanMethods=false)
@MapperScan(value={"plus.hiver.*.dao", "plus.hiver.*.mapper", "plus.hiver.*.dao.mapper"})
public class MybatisPlusConfig {
    @Bean
    @ConditionalOnMissingBean
    public MybatisPlusInterceptor mybatisPlusInterceptor(@Autowired(required=false) List<InnerInterceptor> list) {
        MybatisPlusInterceptor mybatisPlusInterceptor = new MybatisPlusInterceptor();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(innerInterceptor -> mybatisPlusInterceptor.addInnerInterceptor(innerInterceptor));
        }
        mybatisPlusInterceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.POSTGRE_SQL));
        return mybatisPlusInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public HiverSqlInjector batchSqlInjector() {
        return new HiverSqlInjector();
    }

    @Bean
    @ConditionalOnMissingBean
    public MyMetaObjectHandler metaObjectHandler() {
        return new MyMetaObjectHandler();
    }

    @Bean
    @ConditionalOnProperty(prefix="mybatis-plus", name={"sql-print"}, havingValue="true")
    public PerformanceInterceptor performanceInterceptor() {
        return new PerformanceInterceptor();
    }
}

