/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.lock;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import plus.hiver.common.lock.Callback;
import plus.hiver.common.lock.DistributedLockTemplate;

@Component
public class RedisLockTemplate
implements DistributedLockTemplate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisLockTemplate.class);
    @Autowired
    private RedissonClient redisson;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(String string, Integer n, Integer n2, TimeUnit timeUnit, Callback callback) {
        if (n == null) {
            n = 0;
        }
        RLock rLock = null;
        boolean bl = false;
        try {
            rLock = this.redisson.getLock(string);
            bl = n2 == null || n2 <= 0 ? rLock.tryLock((long)n.intValue(), timeUnit) : rLock.tryLock((long)n.intValue(), (long)n2.intValue(), timeUnit);
            if (bl) {
                Object object = callback.onGetLock();
                return object;
            }
            Object object = callback.onTimeout();
            return object;
        }
        catch (InterruptedException interruptedException) {
            log.error(interruptedException.getMessage(), (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        finally {
            if (bl) {
                rLock.unlock();
            }
        }
        return null;
    }
}

